import parser.*;
import rules.*;
import tokens.*;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.io.FileNotFoundException;


public class RDPFrame extends JFrame {
    /**
     * Content pane.
     */
    private JPanel contentPane;

    /**
     * Output text area.
     */
    private JTextArea outputTA = new JTextArea();

    /**
     * Top panel.
     */
    private JPanel topPanel = new JPanel();

    /**
     * Bottom scroll pane.
     */
    private JScrollPane scrollPane = new JScrollPane();

    /**
     * File name input field.
     */
    private JTextField inpFileTF = new JTextField();

    /**
     * Button to parse file.
     */
    private JButton parseBtn = new JButton();

    /**
     * Factory for token visitors to parse S.
     */
    private SFact sFac;

    /**
     * Tokenizer.
     */
    private ITokenizer tkz;

    /**
     * Constructor for the frame.
     */
    public RDPFrame() {
        enableEvents(AWTEvent.WINDOW_EVENT_MASK);
        try {
            jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * Initialize GUI components.
     */
    private void jbInit() {
        //setIconImage(Toolkit.getDefaultToolkit().createImage(RDPFrame.class.getResource("[Your Icon]")));
        contentPane = (JPanel) this.getContentPane();
        contentPane.setLayout(new BorderLayout());

        this.setSize(new Dimension(616, 317));
        this.setTitle("Frame Title");

        inpFileTF.setMinimumSize(new Dimension(100, 21));
        inpFileTF.setPreferredSize(new Dimension(100, 21));
        inpFileTF.setText("inp1.txt");
        inpFileTF.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                parseBtn_actionPerformed(e);
            }
        });

        parseBtn.setText("Parse");
        parseBtn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                parseBtn_actionPerformed(e);
            }
        });

        topPanel.add(inpFileTF, null);
        topPanel.add(parseBtn, null);

        contentPane.add(scrollPane, BorderLayout.CENTER);
        contentPane.add(topPanel, BorderLayout.NORTH);
        scrollPane.getViewport().add(outputTA, null);
    }

    /**
     * Overridden so we can exit when window is closed.
     *
     * @param e window event
     */
    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == WindowEvent.WINDOW_CLOSING) {
            System.exit(0);
        }
    }

    /**
     * Make parser.
     *
     * @throws FileNotFoundException thrown if file is not found
     */
    protected void makeParser() throws FileNotFoundException {
        tkz = new Tokenizer(inpFileTF.getText());

        AFact aFac = new AFact(tkz);
        BFact bFac = new BFact(tkz);
        CFact cFac = new CFact(tkz);
        XFact xFac = new XFact(tkz, aFac, cFac);
        aFac.setXFactory(xFac);
        YFact yFac = new YFact(tkz, xFac, bFac);
        bFac.setYFact(yFac);
        sFac = new SFact(tkz, xFac, yFac);

        System.out.println("Parser Factory = " + sFac);
    }

    /**
     * Parse file.
     *
     * @param e action event
     */
    void parseBtn_actionPerformed(ActionEvent e) {
        try {
            makeParser();

            ITokVisitor parser = sFac.makeVisitor();
            System.out.println("Parser visitor = " + parser);

            Object result = tkz.getNextToken().execute(parser, null);
            tkz.getNextToken().execute(_matchEOF, null);
            System.out.println("Result = " + result);

            outputTA.setText(result.toString());
        }
        catch (Exception e1) {
            StringBuffer sb = new StringBuffer();
            sb.append(e1.toString());
            sb.append('\n');
            StackTraceElement[] ste = e1.getStackTrace();
            for (int i = 0; i < ste.length; ++i) {
                sb.append('\t');
                sb.append(ste[i].toString());
                sb.append('\n');
            }
            outputTA.setText(sb.toString());
            outputTA.setCaretPosition(0);
            e1.printStackTrace();
        }
    }
    
    private ITokVisitor _matchEOF = new EOFToken.IEOFVisitor(){
        public Object eofCase(EOFToken host, Object nu) {
            return host;
        }
        
        public Object defaultCase(AToken host, Object nu) {
            throw new IllegalArgumentException("Wrong token: Expect 'EOF' but get '" + host + "'");
        }
    };}