package tokens;

/**
 * End of file token class.
 */
public class EOFToken extends AToken {
    /**
     * Interface for a visitor to visit an eof token.
     */
    public static interface IEOFVisitor extends ITokVisitor {
        /**
         * Case for an eof token.
         *
         * @param host  eof token
         * @param param visitor-specific parameter
         * @return visitor-specific return value
         */
        public Object eofCase(EOFToken host, Object param);
    }

    /**
     * Abstract class for a chained visitor to visit a plus token. In all non-plus cases, the successor is called.
     */
    public static abstract class AChainVis implements IEOFVisitor {
        /**
         * Successor.
         */
        private ITokVisitor _successor;

        /**
         * Constructor.
         *
         * @param successor visitor to serve as successor in the chain of responsibility.
         */
        protected AChainVis(ITokVisitor successor) {
            _successor = successor;
        }

        /**
         * Continue in the chain of responsibility.
         *
         * @param host  token
         * @param param visitor-specific parameter
         * @return visitor-specific return value
         */
        public Object defaultCase(AToken host, Object param) {
            return host.execute(_successor, param);
        }
    }

    /**
     * Singleton instance.
     */
    public final static EOFToken Singleton = new EOFToken();

    /**
     * Private singleton constructor.
     */
    private EOFToken() {
        super("EOF");
    }

    /**
     * Execute the eof case of the visitor.
     *
     * @param algo  visitor
     * @param param visitor-specific parameter
     * @return visitor-specific return value
     */
    public Object execute(ITokVisitor algo, Object param) {
        return (algo instanceof IEOFVisitor) ?
               ((IEOFVisitor) algo).eofCase(this, param) :
               algo.defaultCase(this, param);
    }
}

