package tokens;

/**
 * Token B class.
 */
public class TokenB extends AToken {
    
    public static interface ITokBVisitor extends ITokVisitor {
      public Object tokBCase(TokenB host, Object param);
    }

    public static abstract class AChainVis implements ITokBVisitor {
        private ITokVisitor _successor;

        protected AChainVis(ITokVisitor successor) {
            _successor = successor;
        }

        public Object defaultCase(AToken host, Object param) {
            return host.execute(_successor, param);
        }
    }

    public final static TokenB Singleton = new TokenB();
    private TokenB() {
        super("b");
    }

    public Object execute(ITokVisitor algo, Object param) {
        return (algo instanceof ITokBVisitor) ?
               ((ITokBVisitor) algo).tokBCase(this, param) :
               algo.defaultCase(this, param);
    }
}

