package rac;

import java.util.*;
import heap.*;

/**
 * An IRACFactory that returns a priority queue.   The ordering of 
 * the queue is determined by a given Comparator object or a default 
 * Comparator that returns the "largest" Comparable element first.
 * Internally, uses a heap to store the data.
 */
public class ArrayPQueueFactory extends AArrayRACFactory {
  
  private int maxSize = 7;  // must be 2^n -1.  Set small here for easier testing.
  private Heapifier heapifier;
  
  /**
   * Used when the items in the container are Comparable objects.
   * The "largest" element has the highest priority.
   */
  public ArrayPQueueFactory() {
    heapifier = new Heapifier(new Comparator() {
      public int compare(Object x, Object y) {
        /*
         * Intentionally reverse the ordering so that the
         * largest item will be first.
         */
        return ((Comparable)y).compareTo(x);
      }
    });
  }
  
  /**
   * Used when we want to prioritize the items according to a given Comparator.
   * @param comp The item that is smallest according to comp has the highest
   * priority. 
   */
  public ArrayPQueueFactory(Comparator comp) {
    heapifier = new Heapifier(comp);    
  }
  
  /**
   * Factory method for the RAC
   */
  public IRAContainer makeRAC() {
    return new AArrayContainer(maxSize){
      
      /**
       * Remove the next item from the container and return it.
       * NOTE: This implies a state change.
       * @throw an IndexOutOfBoundsException if this IRAContainer is empty.
       */
      public Object get() {
        // STUDENT TO COMPLETE
        if(end <= 0) throw new IndexOutOfBoundsException("The RAC is empty.");
        Object result = data[0];
        data[0] = data[end-1];
        end--;
        heapifier.siftDown(data, 0, 0, end-1);
        return result;
      }
      
      
      /**
       * Add an item to the container.
       * NOTE: This implies a state change.
       * @param input the Object to be added to this IRAContainer.
       * @throw an IndexOutOfBOundsException if this IRAContainer is full.
       */
      public void put(Object input) {
        // STUDENT TO COMPLETE
        if(isFull()) throw new IndexOutOfBoundsException("RAC is full.");
        data[end++] = input;    
        heapifier.siftUp(data,0,end-1);
      }
      
      
      /**
       * Return the next element in this IRAContainer withour removing it.
       * @throw an IndexOutOfBoundsException if this IRAContainer is empty.
       */     
      public Object peek() {
        // STUDENT TO COMPLETE
        if(end <= 0) throw new IndexOutOfBoundsException("The RAC is empty.");
        return data[0];
      }
      
    };
  }
  
}