package parser;

import tokens.*;

public class YFact extends ATVFactory {
    private XFact xFact;
    private BFact bFact;
    
    public YFact(ITokenizer tkz, XFact xf, BFact bf) {
        super(tkz);
        xFact = xf;
        bFact = bf;
    }
    
    public ITokVisitor makeVisitor() {
        return xFact.makeChainedVisitor(bFact.makeVisitor());
    }
    

    public ITokVisitor makeChainedVisitor(ITokVisitor succ) {
        return xFact.makeChainedVisitor(bFact.makeChainedVisitor(succ));
    }
}

