package parser;
import genvisitor.*;
import genvisitor.AGenVisitor.*;

/**
 * Abstract algo to check the tags in an XML expression. 
 * Defines the algo to return a boolean and take an Object as its input parameters.
 * Sets the default case to return false.
 */
public abstract class ACheckTagsAlgo extends AGenVisitor<Boolean, String, Object, IGrammarToken> {
  public ACheckTagsAlgo(){
    super(new IGenVisitorCmd<Boolean, String, Object, IGrammarToken>() {
      public Boolean apply(String idx, IGrammarToken host, Object... inps) {
        return false;
      }
    });
  }
}