package parser;
import genvisitor.*;

/**
 * Abstract grammar token that has a name.
 * Executes the case in the visitor corresponding to its name.
 */
public abstract class AGrammarToken implements IGrammarToken {
  private String _name;
  
  public AGrammarToken(String name) {
    _name = name;
  }
  
  public String getName() {
    return _name;
  }

  public <R, P> R execute(IGenVisitor<R, String, P, IGrammarToken> algo, P... inps){
    return algo.caseAt(_name, this, inps);
  }
  
}