package parser;

import genvisitor.*;

/**
 * A visitor to an AToken. 
 */
public abstract class ATokVisitor<R,P> extends AGenVisitor<R, String, P, AToken> implements ITokVisitor<R, P> {
  public ATokVisitor() {
    super( new AGenVisitor.IGenVisitorCmd<R, String, P, AToken>() {
      public R apply(String idx, AToken host, P... inps) {
        throw new IllegalArgumentException("ATokVisitor: No such token: "+ idx);
      }
    });
  }
  
  public ATokVisitor(ATokVisitor<R,P> other) {
    super(other);
  }  
}