package parser;
import genvisitor.*;
import genvisitor.AGenVisitor.*;

/**
 * Algo to check the semantics of a parsed XML file.  
 * Checks if the start tags match their end tags.
 * A simple Id token returns true.
 * An MT token returns true.
 * In general, valid XML produces a sequence of tokens as per the 
 * TaggedElt production rule: TaggedElt ::= < Id > AXML </ Id > 
 * TaggedElt is a chain of 6 SequenceTokens: 
 * below, each [A, B] is a binary SequenceToken: 
 * [<, [Id, [>, [AXML, [</, [Id, >]]]]]]  
 * Note that AXML is always a Sequence whose last token is MT.
 */
public class CheckMatchingTagsAlgo extends ACheckTagsAlgo {
  public static final CheckMatchingTagsAlgo Singleton = new CheckMatchingTagsAlgo();
  
  /**
   * Utility algo to jump to the n'th SequenceToken in a chain.
   */
  private CheckNthSequenceAlgo nthSeq = CheckNthSequenceAlgo.Singleton;
  
  /**
   * Utility algo to process every element in a chain of SequenceTokens
   */
  private ACheckTagsAlgo processList = ProcessListAlgo.Singleton;
  
  
  private CheckMatchingTagsAlgo() {
    // STUDENT TO COMPLETE
    

  
  }
  
}