package parser;
import genvisitor.*;
/**
 * Factory for a binary Combination grammar non-terminal objects.
 */
public class CombinationFact extends ATVFactory {
  
  /**
   * The name of this instance of the factory
   */
  private String _name;
  
  /**
   * Factory for first grammar non-terminals.
   */
  private ITVFactory _fact1;
  
  /**
   * Factory for second grammar non-terminals.
   */
  private ITVFactory _fact2;
  
  /**
   * Constructor for the F factory,
   *
   * @param tkz    tokenizer to use
   * @param f1Fact factory for F1 grammar non-terminals
   * @param f2Fact factory for F2 grammar non-terminals
   */
  public CombinationFact(String name, ITokenizer tkz, ITVFactory fact1, ITVFactory fact2) {
    super(tkz);
    _name = name;
    _fact1 = fact1;
    _fact2 = fact2;
  }
  
  /**
   * Make a token visitor to parse an F non-terminal.
   *
   * @return token visitor
   */
  public ATokVisitor<IGrammarToken, Object> makeVisitor() {
    return _fact1.makeChainedVisitor(_fact2.makeVisitor());
  }
  
  /**
   * Make a token visitor that delegates to the given visitor in a chain of responsibility
   *
   * @param successor visitor to serve as successor in the chain
   */
  public ATokVisitor<IGrammarToken, Object> makeChainedVisitor(ATokVisitor<IGrammarToken, Object> successor) {
    return _fact1.makeChainedVisitor(_fact2.makeChainedVisitor(successor));
  }
}

