package parser;
import genvisitor.*;
import genvisitor.AGenVisitor.*;

/**
 * Map the given ACheckTagsAlgo across all the tokens in a chain (list) of SequenceTokens.
 * The algo is executed on the FIRST token of each SequenceToken and the 
 * result of all the executions is AND'ed together as the final result.
 * That is, the final result is true, only if all the elements individually 
 * calculate to true.
 */
public class ProcessListAlgo extends ACheckTagsAlgo {
  public static final ProcessListAlgo Singleton = new ProcessListAlgo();
  
  private ProcessListAlgo(){
    addCmd("Sequence",new IGenVisitorCmd<Boolean, String, Object, IGrammarToken>() {
      public Boolean apply(String idx, IGrammarToken host, Object... inps) {
        boolean result = ((SequenceToken)host).getToken1().execute((ACheckTagsAlgo)inps[0]);
        return result && ((SequenceToken)host).getToken2().execute(ProcessListAlgo.this, inps);
      }
    });
    addCmd("MT",new IGenVisitorCmd<Boolean, String, Object, IGrammarToken>() {
      public Boolean apply(String idx, IGrammarToken host, Object... inps) {
        return true;   // Empty token at end of chain (list) defaults to true.
      }
    });
  }  
}

