package parser;

import genvisitor.*;

/**
 * '>' token class.
 */
public class RightBracketToken extends AToken {
    /**
     * Singleton instance.
     */
    public final static RightBracketToken Singleton = new RightBracketToken();

    /**
     * Private singleton constructor.
     */
    private RightBracketToken() {
        super(">");
    }

    /**
     * Execute the ">" case of the visitor.
     *
     * @param algo  visitor
     * @param param visitor-specific parameter
     * @return visitor-specific return value
     */
    public <R, P> R execute(IGenVisitor<R, String, P, AToken> algo, P... inps) {
        return algo.caseAt(">", this, inps);
    }
}

