package parser;
import genvisitor.*;

/**
 * Grammar non-terminal -- SeqeuenceToken ::= Token1 Token2
 * Binary sequence
 */
public class SequenceToken extends AGrammarToken {
  /**
   * Token1 object.
   */
  private IGrammarToken _token1;
  
  /**
   * Token2 object.
   */
  private IGrammarToken _token2;
  
  /**
   * Constructor for the sequence token grammar non-terminal.
   *
   * @param token1 IGrammarToken object
   * @param token2 IGrammarToken object
   */
  public SequenceToken(String name, IGrammarToken token1, IGrammarToken token2) {
    super(name);  
    _token1 = token1;
    _token2 = token2;
  }
  
  /**
   * Return a string representation consisting of a String representation of 
   * each of the internal components of E.
   *
   * @return string representation
   */
  public String toString() {
    return _token1.toString() + _token2.toString();
  }
  
  /**
   * Gettor for the first token in the sequence.
   */
  public IGrammarToken getToken1() {return _token1;}
  
  /**
   * Gettor for the second token in the sequence.
   */
  public IGrammarToken getToken2() {return _token2;}
  
  
  public <R, P> R execute(IGenVisitor<R, String, P, IGrammarToken> algo, P... inps){
    return algo.caseAt("Sequence", this, inps);
  }
  
}

