
import parser.*;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.io.FileNotFoundException;


public class RDPFrame extends JFrame {
  /**
   * Content pane.
   */
  private JPanel contentPane;
  
  /**
   * Output text area.
   */
  private JTextArea outputTA = new JTextArea();
  
  /**
   * Top panel.
   */
  private JPanel topPanel = new JPanel();
  
  /**
   * Bottom scroll pane.
   */
  private JScrollPane scrollPane = new JScrollPane();
  
  /**
   * File name input field.
   */
  private JTextField inpFileTF = new JTextField();
  
  /**
   * Button to parse original grammar file.
   */
  private JButton parseOrigBtn = new JButton();
  
  /**
   * Button to parse XML file.
   */
  private JButton parseXMLBtn = new JButton();
  
  /**
   * Button to semantically check the parsed file.
   */
  private JButton checkBtn = new JButton();
  
  
  /**
   * Tokenizer.
   */
  private ITokenizer tok;
  
  /**
   * Constructor for the frame.
   */
  public RDPFrame() {
    enableEvents(AWTEvent.WINDOW_EVENT_MASK);
    try {
      jbInit();
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }
  
  /**
   * Initialize GUI components.
   */
  private void jbInit() {
    //setIconImage(Toolkit.getDefaultToolkit().createImage(RDPFrame.class.getResource("[Your Icon]")));
    contentPane = (JPanel) this.getContentPane();
    contentPane.setLayout(new BorderLayout());
    
    this.setSize(new Dimension(616, 317));
    this.setTitle("Frame Title");
    
    inpFileTF.setMinimumSize(new Dimension(100, 21));
    inpFileTF.setPreferredSize(new Dimension(100, 21));
//    inpFileTF.setText("inp1.txt");
    inpFileTF.setText("xml1.txt");
//    inpFileTF.addActionListener(new java.awt.event.ActionListener() {
//      public void actionPerformed(ActionEvent e) {
//        parseXMLBtn_actionPerformed(e);
//      }
//    });
    
    parseOrigBtn.setText("Parse Orig");
    parseOrigBtn.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        parseOrigBtn_actionPerformed(e);
      }
    });
    
    parseXMLBtn.setText("Parse XML");
    parseXMLBtn.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        parseXMLBtn_actionPerformed(e);
      }
    });
    
    checkBtn.setText("Check XML result");
    checkBtn.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        checkBtn_actionPerformed(e);
      }
    });
    
    topPanel.add(inpFileTF, null);
    topPanel.add(parseOrigBtn, null);
    topPanel.add(parseXMLBtn, null);
    topPanel.add(checkBtn, null);
    
    contentPane.add(scrollPane, BorderLayout.CENTER);
    contentPane.add(topPanel, BorderLayout.NORTH);
    scrollPane.getViewport().add(outputTA, null);
  }
  
  /**
   * Overridden so we can exit when window is closed.
   *
   * @param e window event
   */
  protected void processWindowEvent(WindowEvent e) {
    super.processWindowEvent(e);
    if (e.getID() == WindowEvent.WINDOW_CLOSING) {
      System.exit(0);
    }
  }
  
  /**
   * Make original grammar parser.
   *  
   *  E ::= F E1
   *  F ::= F1 | F2
   *  F1 ::= NumToken
   *  F2 ::= IdToken
   *  E1 ::= E1a | Empty
   *  E1a ::= + E
   * 
   * @throws FileNotFoundException thrown if file is not found
   */
  protected ITVFactory makeOrigParser() throws FileNotFoundException {
    tok = new Tokenizer3(inpFileTF.getText());
//    tok = new Tokenizer4(inpFileTF.getText());
    
    
    //---- Student to comment out the code below ------
    
    // The old way of instantiating the grammar:
    
    E1aFact e1aFac = new E1aFact(tok);
    ITVFactory eFact = new EFact(tok,
                      new FFact(tok, 
                                new F1Fact(tok), 
                                new F2Fact(tok)),
                      new E1Fact(tok, 
                                 e1aFac, 
                                 new EmptyFact(tok)));
    
    e1aFac.setParseEFactory((EFact)eFact);
    
    //----- Student to comment out the code above ---------
    
    // STUDENT TO COMPLETE:
    // Replace the above code with code that only uses 
    // SequenceFact, CombinationFact, SimpleFact, MTFact, 
    // and/or MultiSequenceFact
    
    // The new way of instantiating the old grammar:
/*
    ProxyFact eFact_Proxy = new ProxyFact();
    
    ITVFactory eFact = new MultiSequenceFact("E", tok,
                                             new CombinationFact("F", tok, 
                                                                 new SimpleFact("Num", tok), 
                                                                 new SimpleFact("Id", tok)),
                                             new CombinationFact("E1", tok, 
                                                                 new MultiSequenceFact("E1a", tok, 
                                                                                       new SimpleFact("+", tok), 
                                                                                       eFact_Proxy), 
                                                                 new MTFact(tok)));
    
    eFact_Proxy.setFact(eFact);
*/
    
    System.err.println("Parser Factory = " + eFact);
    
    return eFact;
  }
  
  /**
   * Parse file.
   *
   * @param e action event
   */
  void parseOrigBtn_actionPerformed(ActionEvent e) {
    try {
      ITVFactory origParseFact = makeOrigParser();
      
      ITokVisitor<IGrammarToken, Object> parser = origParseFact.makeVisitor();
      System.err.println("Parser visitor = " + parser);
      
      result = tok.getNextToken().execute(parser);
      System.err.println("Result = " + result);
      
      outputTA.setText(result.toString());
    }
    catch (Exception e1) {
      StringBuffer sb = new StringBuffer();
      sb.append(e1.toString());
      sb.append('\n');
      StackTraceElement[] ste = e1.getStackTrace();
      for (int i = 0; i < ste.length; ++i) {
        sb.append('\t');
        sb.append(ste[i].toString());
        sb.append('\n');
      }
      outputTA.setText(sb.toString());
      outputTA.setCaretPosition(0);
      e1.printStackTrace();
    }
  }
  
  /**
   * Make XML parser.
   *
   * TaggedElt ::= < Id > AXML </ Id > 
   * AXML  ::=  NEXML | MT   
   * NEXML ::=  AElement AXML 
   * AElement ::=  Id | TaggedElt 
   * 
   * Notes:
   * MT = empty token
   * "</" is a single token above, not two tokens
   * 
   * @throws FileNotFoundException thrown if file is not found
   */
  protected ITVFactory makeXMLParser() throws FileNotFoundException {
    tok = new Tokenizer3(inpFileTF.getText());
//    tok = new Tokenizer4(inpFileTF.getText());  
    
    ITVFactory leftBracketFact = new SimpleFact("<", tok);
    ITVFactory rightBracketFact = new SimpleFact(">", tok);
    ITVFactory forwardSlashFact = new SimpleFact("/", tok);
    ITVFactory idFact = new SimpleFact("Id", tok);
    ITVFactory leftBracketForwardSlashFact = new SimpleFact("</", tok);
    
    // STUDENT TO COMPLETE
    
    
    ProxyFact taggedElt_Proxy = new ProxyFact();
    
    ProxyFact aXML_Proxy = new ProxyFact();
        
    ITVFactory aXML = new CombinationFact("AXML", tok,
                                          new MultiSequenceFact("NEXML", tok,
                                                                new CombinationFact("AElement", tok,
                                                                                    idFact, taggedElt_Proxy),
                                                                aXML_Proxy), 
                                          new MTFact(tok));
    aXML_Proxy.setFact(aXML);
    
    ITVFactory taggedElt = new MultiSequenceFact("EFac", tok,
                                                 leftBracketFact, idFact, rightBracketFact,
                                                 aXML, 
                                                 leftBracketForwardSlashFact, idFact, rightBracketFact);
    
    taggedElt_Proxy.setFact(taggedElt);
    
    System.err.println("Parser Factory = " + taggedElt);
    
    return taggedElt;
  }
  
  IGrammarToken result;
  
  /**
   * Parse file.
   *
   * @param e action event
   */
  void parseXMLBtn_actionPerformed(ActionEvent e) {
    try {
      ITVFactory xmlParseFact = makeXMLParser();
      
      ITokVisitor<IGrammarToken, Object> parser = xmlParseFact.makeVisitor();
      System.err.println("Parser visitor = " + parser);
      
      result = tok.getNextToken().execute(parser);
      System.err.println("Result = " + result);
      
      outputTA.setText(result.toString());
    }
    catch (Exception e1) {
      StringBuffer sb = new StringBuffer();
      sb.append(e1.toString());
      sb.append('\n');
      StackTraceElement[] ste = e1.getStackTrace();
      for (int i = 0; i < ste.length; ++i) {
        sb.append('\t');
        sb.append(ste[i].toString());
        sb.append('\n');
      }
      outputTA.setText(sb.toString());
      outputTA.setCaretPosition(0);
      e1.printStackTrace();
    }
  }
  
  void checkBtn_actionPerformed(ActionEvent e) {
    boolean isOk = result.execute(CheckMatchingTagsAlgo.Singleton);
    outputTA.append("\n"+"Check result: "+ isOk);
  }
  
  
}