package parser;
import genvisitor.*;
import genvisitor.AGenVisitor.*;

/**
 * Algo to run a given ACheckTagsAlgo on the n'th (starting at zero) 
 * SequenceToken in a linear list of chained SequenceTokens (ie. connected
 * via their second tokens).
 * Note that the given algo is executed on the n'th SequenceToken in the
 * chain, not the first token of that SequenceToken.   This allows the given
 * algo to continue recurring down the chain.
 * The first input is the number of the SequenceToken to go to, starting at zero.
 * The second input is the algo for that SequenceToken to execute (no input params).
 */
public class CheckNthSequenceAlgo extends ACheckTagsAlgo {
  public static final CheckNthSequenceAlgo Singleton = new CheckNthSequenceAlgo();
  
  private CheckNthSequenceAlgo(){
    addCmd("Sequence", new IGenVisitorCmd<Boolean, String, Object, IGrammarToken>() {
      public Boolean apply(String idx, IGrammarToken host, Object... inps) {
        int n = (Integer) inps[0];
        if(0 == n){ // Found it!
          // Run the given algo on the host, NOT host.getToken1()!
          return ((SequenceToken)host).execute((ACheckTagsAlgo) inps[1]);
        }
        else {
          // Keep counting down
          return ((SequenceToken)host).getToken2().execute(CheckNthSequenceAlgo.this, --n, inps[1]);
        }
      }
    });
  }
}
  