package parser;
import genvisitor.*;
/**
 * Factory for E grammar non-terminal objects.
 */
public class EFact extends ATVFactory {
  /**
   * Factory for F grammar non-terminals.
   */
  private FFact _fFact;
  
  /**
   * Visitor for F grammar non-terminals.
   */
  private ATokVisitor<IGrammarToken, Object> _parseF;
  
  /**
   * Factory for E1 grammar non-terminals.
   */
  private E1Fact _e1Fact;
  
  /**
   * Visitor for E1 grammar non-terminals.
   */
  private ATokVisitor<IGrammarToken, Object> _parseE1;
  
  /**
   * Initializer lambda for this factory.
   */
  private ILambda _initializer = new ILambda() {
    public Object apply(Object param) {
      // change state to no-op
      _initializer = NoOpLambda.Singleton;
      
      // initialize
      _parseF = _fFact.makeVisitor();
      _parseE1 = _e1Fact.makeVisitor();
      return null;
    }
  };
  
  /**
   * Constructor for the E factory,
   *
   * @param tkz    tokenizer to use
   * @param fFact  factory for F non-terminals
   * @param e1Fact factory for E1 non-terminals
   */
  public EFact(ITokenizer tkz, FFact fFact, E1Fact e1Fact) {
    super(tkz);
    _fFact = fFact;
    _e1Fact = e1Fact;
  }
  
  
  /**
   * Make a token visitor to parse an E non-terminal.
   *
   * @return token visitor
   */
  public ATokVisitor<IGrammarToken, Object> makeVisitor() {
    initialize();
    // STUDENT TO COMPLETE
    return new ATokVisitor<IGrammarToken, Object>(_parseF)
    {
      {
        // Decorate every command that was copied from _parseF
        map(new AGenVisitor.IMapLambda<String, AGenVisitor.IGenVisitorCmd<IGrammarToken, String, Object, AToken>>() {
          public AGenVisitor.IGenVisitorCmd<IGrammarToken, String, Object, AToken> apply(String idx, final AGenVisitor.IGenVisitorCmd<IGrammarToken, String, Object, AToken> cmd) {
            return new AGenVisitor.IGenVisitorCmd<IGrammarToken, String, Object, AToken>() {
              public IGrammarToken apply(String idx, AToken host, Object... inps) {
                return new E((F)cmd.apply(idx, host, inps), (E1) nextToken().execute(_parseE1, inps));
              }
            };
          }
        });
      }
    };
  }
  
  /**
   * Make a token visitor that delegates to the given visitor in a chain of responsibility
   *
   * @param successor visitor to serve as successor in the chain
   */
  public ATokVisitor<IGrammarToken, Object> makeChainedVisitor(ATokVisitor<IGrammarToken, Object> successor) {
    initialize();
    // STUDENT TO COMPLETE
    
    final ATokVisitor<IGrammarToken, Object> v = makeVisitor();
    // Copy all cmds from successor to v
    successor.map(new AGenVisitor.IMapLambda<String, AGenVisitor.IGenVisitorCmd<IGrammarToken, String, Object, AToken>>() {
      public AGenVisitor.IGenVisitorCmd<IGrammarToken, String, Object, AToken> apply(String idx, final AGenVisitor.IGenVisitorCmd<IGrammarToken, String, Object, AToken> cmd) {
        v.addCmd(idx, cmd);   // copy command to v
        return cmd;  // put cmd back in successor
      }
    });
    return v;
  }
  
  /**
   * Make the visitor.
   */
  private void initialize() {
    _initializer.apply(null);
  }
}

