package parser;

import genvisitor.*;

/**
 * '/' token class.
 */
public class ForwardSlashToken extends AToken {
    /**
     * Singleton instance.
     */
    public final static ForwardSlashToken Singleton = new ForwardSlashToken();

    /**
     * Private singleton constructor.
     */
    private ForwardSlashToken() {
        super("/");
    }

    /**
     * Execute the "/" case of the visitor.
     *
     * @param algo  visitor
     * @param param visitor-specific parameter
     * @return visitor-specific return value
     */
    public <R, P> R execute(IGenVisitor<R, String, P, AToken> algo, P... inps) {
      return algo.caseAt("/", this, inps);
    }
}

