package parser;

/**
 * Interface for an abstract factory for token visitors.
 */
public interface ITVFactory {
    /**
     * Make a token visitor.
     *
     * @return token visitor
     */
    public abstract ATokVisitor<IGrammarToken, Object> makeVisitor();

    /**
     * Make a token visitor that delegates to the given visitor in a chain of responsibility
     *
     * @param successor visitor to serve as successor in the chain
     */
    public abstract ATokVisitor<IGrammarToken, Object> makeChainedVisitor(ATokVisitor<IGrammarToken, Object> successor);
}

