package parser;

import genvisitor.*;

/**
 * '<' token class.
 */
public class LeftBracketToken extends AToken {
    /**
     * Singleton instance.
     */
    public final static LeftBracketToken Singleton = new LeftBracketToken();

    /**
     * Private singleton constructor.
     */
    private LeftBracketToken() {
        super("<");
    }

    /**
     * Execute the "<" case of the visitor.
     *
     * @param algo  visitor
     * @param param visitor-specific parameter
     * @return visitor-specific return value
     */
    public <R, P> R execute(IGenVisitor<R, String, P, AToken> algo, P... inps) {
        return algo.caseAt("<", this, inps);
    }
}

