package parser;

import genvisitor.*;

/**
 * Factory for Empty grammar terminals.
 */
public class MTFact extends ATVFactory {
  /**
   * Constructor for Empty grammar terminals.
   *
   * @param tkz tokenizer to use
   */
  public MTFact(ITokenizer tkz) {
    super(tkz);
  }
  
  
  
  /**
   * Make a visitor to parse an empty terminal.
   *
   * @return visitor to parse an empty terminal
   */
  
  private AGenVisitor.IGenVisitorCmd<IGrammarToken, String, Object, AToken> makeCmd() {
    return new AGenVisitor.IGenVisitorCmd<IGrammarToken, String, Object, AToken>() {
      public IGrammarToken apply(String idx, AToken host, Object... inps) {
        putBackToken();
        System.out.println("MTFact: Pushback");
        return MT.Singleton;      }
    };
  }
  
  /**
   * Make a token visitor to parse an Empty terminal.
   *
   * @return token visitor
   */
  public ATokVisitor<IGrammarToken, Object> makeVisitor() {
    return new ATokVisitor<IGrammarToken, Object>(){
      {
        setDefaultCmd(makeCmd());
      }
    };
  }
  
  /**
   * Make a token visitor that delegates to the given visitor in a chain of responsibility
   *
   * @param successor visitor to serve as successor in the chain
   */
  public ATokVisitor<IGrammarToken, Object> makeChainedVisitor(ATokVisitor<IGrammarToken, Object> successor) {
    return new ATokVisitor<IGrammarToken, Object>(successor) {
      {
        setDefaultCmd(makeCmd());
      }
    };
  }
}

