package parser;

import genvisitor.*;
/**
 * Number token class.
 */
public class NumToken extends AToken {

    /**
     * Constructor for a number token.
     *
     * @param lexeme number lexeme
     */
    public NumToken(String lexeme) {
        super(lexeme);
    }

    /**
     * Execute the number case of the visitor.
     *
     * @param algo  visitor
     * @param param visitor-specific parameter
     * @return visitor-specific return value
     */
    public <R, P> R execute(IGenVisitor<R, String, P, AToken> algo, P... inps) {
        return algo.caseAt("Num", this, inps); 
    }
}

