package dijkstra;
import listFW.*;

/**
 * Algorithm to return a string representation of an
 * IList<VertexDistDyad> where the distances are the 
 * *total* distance to that vertex along the path.  
 * The list is assumed to be in reverse order, i.e. the
 * last vertex in the path is the first and the starting
 * vertex is next to the empty list. 
 * The output reverses the order of the list, giving the 
 * vertices in the order of the path (start to last).
 * The distances indicated are the distances *between* 
 * the vertices.
 * 
 * Example:  ((C, 50), (B, 20), (A, 0)) returns 
 * A =20=> B =30=> C
 */
public class PathToString implements IListAlgo<VertexDistDyad, String, Object> {
  public static final PathToString Singleton = new PathToString();
  private  PathToString() {}
  
  public String emptyCase(IMTList<? extends VertexDistDyad> host, Object... nu) {
    return "";
  }
  
  public String nonEmptyCase(INEList<? extends VertexDistDyad> host, Object... nu) {
    return host.getRest().execute(helper, host.getFirst().getDistance()) + host.getFirst().getVertex().getName();
  }
  
  private IListAlgo<VertexDistDyad, String, Integer> helper = new IListAlgo<VertexDistDyad, String, Integer> () {
    
    public String emptyCase(IMTList<? extends VertexDistDyad> host, Integer...distances) {
      return "";
    }
    
    public String nonEmptyCase(INEList<? extends VertexDistDyad> host, Integer... distances) {
      String result = " ="+(distances[0]-host.getFirst().getDistance()) +"=> ";
      return host.getRest().execute(helper, host.getFirst().getDistance())
        + host.getFirst().getVertex().getName()
        + result ;
    }
  };
}