package dijkstra;
import java.util.*;
import rac.*;
import listFW.*;
import listFW.factory.*;

/**
 * Class that describes a vertex on a weighted graph
 * A vertex consists of a name and a Set of IPath, 
 * which contain the name and distance of the next 
 * vertices from this vertex
 */
public class Vertex {
  
  /**
   * Well-define Null object for use where appropriate
   * Has empty string for name.
   * Has empty set for next.
   */
  public static Vertex NULL_OBJECT = new Vertex(""){
    public boolean equals(Object o) {
      return this == o;
    }
    public String toString() {
      return "";
    }
    
  };
  /**
   * The name of this vertex
   */
  private String name;
  
  /**
   * The neighbors of this vertex, described as a set of paths,
   * where the path is from this vertex to the neighbor and the 
   * distance is the weight of that connection.
   */
  private Set<VertexDistDyad> next = new HashSet<VertexDistDyad>();
  
  /**
   * Constructor for the class.  Does not set the neighbors.
   * @param name the name of the vertex
   */
  public Vertex(String name) {
    this.name = name;
  }
  
  
  /**
   * Accessor for the name of the vertex
   */
  public String getName() {
    return name;
  }
  
  /**
   * Sets the set of vertices that are directly connected 
   * from this vertex to them.
   * The vertices are defined in terms of VertexDistDyads 
   * which give the vertex itself, the distance from this
   * vertex and have their previous vertex set to this vertex.
   */
  public void setNext(Set<VertexDistDyad> next) {
    this.next = next;
  }
  
  public void makeNext(Vertex[] neighbors, int[] distances) {
    for(int i=0; i< neighbors.length; i++) {
      next.add(new VertexDistDyad(neighbors[i], distances[i]));
    }  
  }

  /**
   * Accessor for the set of next vertices
   */
  public Set<VertexDistDyad> getNext() {
    return next;
  }
  
  /**
   * Equals is determined by the name of the vertex only
   */
  public boolean equals(Object o) {
    if( o instanceof Vertex) {
      return ((Vertex)o).getName().equals(this.getName());
    }
    else return false;
  }  
  
  /**
   * Returns a String with the entire graph starting from 
   * this vertex
   */
  public String toString() {
    return toStringHelp( new HashSet<Vertex>());
  }
  
  /**
   * Helper method for toString
   * @param seen The set of vertices already displayed, to eliminate loops.
   */
  private String toStringHelp(Set<Vertex> seen) {
    if(seen.contains(this)) return ""; 
    else {
      String result = "["+name+"] ==> { ";
      for(VertexDistDyad vdd : next) {
        result += vdd.getVertex().getName()+"["+vdd.getDistance()+"] ";
      }
      result += "}\n";
      seen.add(this);
      for(VertexDistDyad vdd : next) {
        result += vdd.getVertex().toStringHelp(seen);
      }
      return result;
    }
  }
  
  /**
   * implementation of the Dijkstra Shortest-Path Algorithm
   * to calculate the shortest path through the graph from
   * this vertex to the given vertex.
   * @param target The target vertex
   * @return A VertexDisDyad whose vertex is the target, whose distance is the total distance from this vertex and whos previous is the previous vertex in the path.
   */
  public IList<VertexDistDyad> shortestPathTo(Vertex target) {
    IListFactory<VertexDistDyad> fac = new CompositeListFactory<VertexDistDyad>();
    
    IRAContainer<INEList<VertexDistDyad>>  pQueue = (new DijkstraPQueueFactory()).makeRAC();
    try {
      // STUDENT TO COMPLETE
 
      
      
    }
    catch(Exception e) {
      System.err.println("Vertex.shortestPathTo: "+e);
      e.printStackTrace();
      System.out.println("RAC = "+pQueue.elements(new listFW.factory.CompositeListFactory<INEList<VertexDistDyad>>()));
      return null;
    }
  }
}
