package dijkstra;

/** 
 * Class that represents a vertex-distance pair (dyad).
 * This clas does NOT specify what the distance is measured
 * to, i.e. it may not be the simple distance/weight of 
 * a single graph edge, but may instead be a compound value.
 */
public class VertexDistDyad {

  
  private Vertex vertex;
  private int distance;
  
  /**
   * General constructor for the class taking all three parameters
   */
  public VertexDistDyad(Vertex vertex, int distance) {
    this.vertex = vertex;
    this.distance = distance;
  }
  
  /**
   * Accessor for the stored vertex
   */
  public Vertex getVertex() {
    return vertex;
  }
  
  /**
   * Accessor to the stored distance
   */
  public int getDistance() {
    return distance;
  }
  
  public String toString() {
    return "("+vertex.getName()+", "+distance+")";
  }
  
}
