package dijkstra.test;

import dijkstra.*;
import java.util.*;
import listFW.*;

import junit.framework.TestCase;

/**
 * A JUnit test case class.
 * Every method starting with the word "test" will be called when running
 * the test with JUnit.
 */
public class Test_Dijkstra extends TestCase {
  

  public void test_Vertex() {
    Vertex vA = new Vertex("A");
    Vertex vB = new Vertex("B");
    Vertex vC = new Vertex("C");
    Vertex vD = new Vertex("D");
    Vertex vE = new Vertex("E");
    Vertex vF = new Vertex("F");
    
    vA.makeNext(new Vertex[]{vB, vD}, new int[]{20, 15});
    vB.makeNext(new Vertex[]{vC, vA}, new int[]{50, 15});
    vC.makeNext(new Vertex[]{vA}, new int[]{10});
    vD.makeNext(new Vertex[]{vE, vB, vC}, new int[]{5, 15, 25});
    vE.makeNext(new Vertex[]{vA, vC, vB}, new int[]{5, 10, 25});
    vF.makeNext(new Vertex[]{vC, vA}, new int[]{30, 60});
    
    System.out.println(vA+"\n");
    
    IList<VertexDistDyad> shortest = vA.shortestPathTo(vC);
    System.out.println(shortest.toString());
    System.out.println("Path: "+shortest.execute(PathToString.Singleton)+"\n");
    assertEquals("A --> C", "((C, 30), (E, 20), (D, 15), (A, 0))", shortest.toString());

    shortest = vA.shortestPathTo(vF);
    System.out.println("A --> F has no path.  Should be empty list: "+shortest.toString());
    System.out.println("Path: "+shortest.execute(PathToString.Singleton)+"\n");
    assertEquals("A --> F", "()", shortest.toString());
  
    shortest = vB.shortestPathTo(vE);
    System.out.println("B --> E: " + shortest.toString());
    System.out.println("Path: "+shortest.execute(PathToString.Singleton)+"\n");
    assertEquals("B --> E", "((E, 35), (D, 30), (A, 15), (B, 0))", shortest.toString());

    shortest = vD.shortestPathTo(vA);
    System.out.println("D --> A: " + shortest.toString());
    System.out.println("Path: "+shortest.execute(PathToString.Singleton)+"\n");
    assertEquals("D --> A", "((A, 10), (E, 5), (D, 0))", shortest.toString());
  }
 
  
  public void test_TexasDistanceMap() {
    Vertex vHouston = new Vertex("Houston");
    Vertex vDallas = new Vertex("Dallas");
    Vertex vAustin = new Vertex("Austin");
    Vertex vSan_Antonio = new Vertex("San Antonio");
    Vertex vLubbock = new Vertex("Lubbock");
    Vertex vBrownsville = new Vertex("Brownsville");
    Vertex vEl_Paso = new Vertex("El Paso");
    
    vHouston.makeNext(new Vertex[]{vDallas, vAustin, vSan_Antonio}, new int[]{240, 265, 200});
    vDallas.makeNext(new Vertex[]{vHouston, vAustin, vLubbock}, new int[]{240, 195, 350});
    vAustin.makeNext(new Vertex[]{vDallas, vHouston, vSan_Antonio, vLubbock}, new int[]{195, 265, 80, 420});
    vLubbock.makeNext(new Vertex[]{vDallas, vAustin, vEl_Paso}, new int[]{350, 420, 350});   
    vSan_Antonio.makeNext(new Vertex[]{vAustin, vHouston, vBrownsville, vEl_Paso}, new int[]{80, 200, 275, 555});
    vBrownsville.makeNext(new Vertex[]{vEl_Paso, vSan_Antonio}, new int[]{830, 275});
    vEl_Paso.makeNext(new Vertex[]{vBrownsville, vSan_Antonio, vLubbock}, new int[]{830, 555, 350});

    System.out.println(vHouston+"\n");
  
    IList<VertexDistDyad> shortest = vHouston.shortestPathTo(vLubbock);
    System.out.println("Houston --> Lubbock: "+ shortest.toString());
    System.out.println("Path: "+shortest.execute(PathToString.Singleton)+"\n");
    assertEquals("Houston --> Lubbock", "((Lubbock, 590), (Dallas, 240), (Houston, 0))", shortest.toString());

    shortest = vDallas.shortestPathTo(vEl_Paso);
    System.out.println("Dallas --> El Paso: "+ shortest.toString());
    System.out.println("Path: "+shortest.execute(PathToString.Singleton)+"\n");
    assertEquals("Dallas --> El Paso", "((El Paso, 700), (Lubbock, 350), (Dallas, 0))", shortest.toString());

    shortest = vLubbock.shortestPathTo(vBrownsville);
    System.out.println("Lubbock --> Brownsville: "+ shortest.toString());
    System.out.println("Path: "+shortest.execute(PathToString.Singleton)+"\n");
    assertEquals("Lubbock --> Brownsville", "((Brownsville, 775), (San Antonio, 500), (Austin, 420), (Lubbock, 0))", shortest.toString());

  }  
}
