package heap.test;

import heap.*;
import java.util.*;
import junit.framework.TestCase;


public class Test_Heapifier extends TestCase {
  
  private Comparator comp = new Comparator() {
    public int compare(Object x, Object y) {
      /*
       * Intentionally reverse the ordering so that the
       * largest item will be first.
       */
      return ((Comparable)x).compareTo(y);
    }
  };
  
  Heapifier<Integer> heapifier = new Heapifier<Integer>(comp);
  
  public void test_heap() {
    Integer[] A =  {999, 50, 80, 20, 60, 90, 40, 30, 70, 10, -999};
    int arrayLen = A.length;
    
    int lo = 1;
    int hi = arrayLen - 2;
    
    for (int cur = (hi - lo + 1) / 2; cur >= lo; cur--) {
      heapifier.siftDown (A, lo, cur, hi);
    }
    
    assertEquals("Heapified A[1...9]", "[999 10 50 20 60 90 40 30 70 80 -999]", arrayToString(A));
    
    heapifier.siftUp (A, lo, hi + 1);
    
    assertEquals("Heapified A[1...10]", "[999 -999 10 20 60 50 40 30 70 80 90]", arrayToString(A));    
    
  }
  
  private String arrayToString(Object[] x) {
    String s = "[";
    if(x.length >=1) s += x[0];
    for(int i = 1; i< x.length; i++) s += " " +x[i];
    return s + "]";
  }
}
