package listFW;

/**
 * Represents the structural behavior of an immutable non-empty list
 * that holds elements of type E.
 * An immutable non-empty list has a data object called first, and an
 * isomorphic subcomponent called rest.  Its structural behavior
 * provides access to its internal data (first) and substructure (rest).
 * @author Dung X. Nguyen
 * @author Stephen B. Wong
 * @since Copyright 2004 - DXN, SBW All rights reserved
 */
public interface INEList<E> extends IList<E> {
    /**
     * "Gettor" method for the list's first.
     * @return this INElist's first element.
     */
    public abstract E getFirst();

    /**
     * "Gettor" method for the list's rest.
     * @return this INElist's rest.
     */
    public abstract IList<? extends E> getRest();
}

