package rac;

import listFW.*;
import listFW.factory.*;


public abstract class AArrayRACFactory<E> implements IRACFactory<E> {
  
  protected abstract class AArrayContainer<E> implements IRAContainer<E> {
    
    /**
     * A fixed size array that holds the RAC's data
     * The data is assumed to completely fill the array
     * from data[0] up to, but NOT including, data[end].
     */
    protected E[] data;
    
    /**
     * An index that references the element right AFTER
     * the last element in the RAC's array
     */
    protected int end = 0;

    public AArrayContainer(E[] data) {
      this.data = data;
    }
        
    public void clear() {
      end = 0;
    }
    
    public boolean isFull() {
      return end >= data.length;
    }
    
    
    /**
     * Returns an IList of the elements in the RAC,
     * in the order that they are held in the 
     * the data array.
     */
    public IList<E> elements(IListFactory<E> fact) {
      IList l = fact.makeEmptyList();
      for(int i = end-1; i>=0; i--) {
        l = fact.makeNEList(data[i], l);
      }
      return l;
    }
       
    public <R, P> R execute(IRACVisitor<? super E, R, P> v, P... inp) {
      if(end<=0) return v.emptyCase(this, inp);
      else return v.nonEmptyCase(this, inp);
    }
  }
}