package rac;

import listFW.*;

/**
 * Defines the interface for a restricted access container.
 */
public interface IRAContainer<E> {
    /**
     * Empty the container.
     * NOTE: This implies a state change.
     * This behavior can be achieved by repeatedly removing elements from this IRAContainer.
     * It is specified here as a convenience to the client.
     */
    public abstract void clear();


    /**
     * Return TRUE if the container is full; otherwise, return
     * FALSE. 
     */
    public abstract boolean isFull();

    /**
     * Return an immutable list of all elements in the container.
     * @param fact for manufacturing an IList.
     */
    public abstract IList<E> elements(IListFactory<E> fact);

    /**
     * Remove the next item from the container and return it.
     * NOTE: This implies a state change.
     * @throw an Exception if this IRAContainer is empty.
     */
    public abstract E get();

    /**
     * Add an item to the container.
     * NOTE: This implies a state change.
     * @param input the Object to be added to this IRAContainer.
     * @throw an Exception if this IRAContainer is full.
     */
    public abstract void put(E input);
    
    /**
     * Return the next element in this IRAContainer withour removing it.
     * @throw an Exception if this IRAContainer is empty.
     */
    public abstract E peek();
    
        /**
     * Extensibility hook to accept a visitor algorithm.
     * @param v  The visitor to execute
     * @param param An arbitrary input parameter for the visitor
     * @return The return value of the calculation performed by the visitor.
     */

    public abstract <R, P> R execute(IRACVisitor<? super E, R, P> v, P... inp); 
}
