package rac.test;

import rac.*;
import rac.visitor.*;
import listFW.factory.*;
import java.util.*;
import junit.framework.TestCase;

public class Test_ArrayPQueueFactory extends TestCase {
  
  
  
  public void test_ArrayPQueue_descend() {
    IRACFactory fac = new ArrayPQueueFactory();
    IRAContainer rac = fac.makeRAC();
    
    assertTrue("Empty RAC", (Boolean) rac.execute(IsEmpty.Singleton));
    try {
      rac.peek();
      fail("RAC(empty).peek() -- Should have thrown exception");
    }
    catch(IndexOutOfBoundsException e) {
      // pass
    }
    catch(Exception e) {
      fail("RAC(empty).peek() -- wrong exception: "+ e);
    }
    
    try {
      rac.get();
      fail("RAC(empty).get() -- Should have thrown exception");
    }
    catch(IndexOutOfBoundsException e) {
      // pass
    }
    catch(Exception e) {
      fail("RAC(empty).get() -- wrong exception: "+ e);
    }
    
    rac.put(42);
    
    assertEquals("RAC(42)", 42, rac.get());
    assertTrue("Empty RAC", (Boolean)  rac.execute(IsEmpty.Singleton));
    
    rac.put(10);
    rac.put(15);
    
    assertEquals("RAC(10, 15).peek()", 15, rac.peek());
    assertEquals("RAC(10, 15).get()", 15, rac.get());
    assertEquals("RAC(10).get()", 10, rac.get());
    assertTrue("Empty RAC", (Boolean) rac.execute(IsEmpty.Singleton));
    
    rac.put(32);
    rac.put(7);
    
    assertEquals("RAC(32, 7)", 32, rac.get());
    assertEquals("RAC(7)", 7, rac.get());
    assertTrue("Empty RAC", (Boolean) rac.execute(IsEmpty.Singleton));
    
    rac.put(10);
    rac.put(5);
    rac.put(23);
    rac.put(31);
    rac.put(-5);
    rac.put(-2);
    rac.put(50);
    
    assertTrue("Full RAC", rac.isFull());
    
    try {
      rac.put(100);
      fail("RAC(full).put(x) -- Should have thrown exception");
    }
    catch(IndexOutOfBoundsException e) {
      // pass
    }
    catch(Exception e) {
      fail("RAC(full).put(x) -- wrong exception: "+ e);
    }
    
    
    assertEquals("RAC(10,5,23,31,-5,-2,50)", "(50, 23, 31, 5, -5, -2, 10)", 
                 rac.elements(new CompositeListFactory<Integer>()).toString());
    assertEquals("RAC(10,5,23,31,-5,-2,50).get()",50,rac.get());
    assertEquals("RAC(10,5,23,31,-5,-2).get()",31,rac.get());
    assertEquals("RAC(10,5,23,-5,-2).get()",23,rac.get());
    assertEquals("RAC(10,5,-5,-2).get()",10,rac.get());
    assertEquals("RAC(5,-5,-2).get()",5,rac.get());
    assertEquals("RAC(-5,-2).get()",-2,rac.get());
    assertEquals("RAC(-5).get()",-5,rac.get());
    assertTrue("Empty RAC", (Boolean) rac.execute(IsEmpty.Singleton));
  }
  
  public void test_ArrayPQueue_ascend() {
    IRACFactory fac = new ArrayPQueueFactory(new Comparator() {
      public int compare(Object x, Object y) {
        /*
         * Intentionally reverse the ordering so that the
         * largest item will be first.
         */
        return ((Comparable)x).compareTo(y);
      }
    });
    IRAContainer rac = fac.makeRAC();
    
    rac.put(10);
    rac.put(15);
    
    assertEquals("RAC(10, 15).peek()", 10, rac.peek());
    assertEquals("RAC(10, 15).get()", 10, rac.get());
    assertEquals("RAC(15).get()", 15, rac.get());
    assertTrue("Empty RAC", (Boolean) rac.execute(IsEmpty.Singleton));
    
  }  
}
