
package model;
import GameIO.*;

/**
 * This class represents an abstract player of the game.    The players are represented as a circular linked list.
 */
public abstract class APlayer
{
	private IRequestor iRequestor;
	private int player;
	private APlayer nextPlayer = this;
	/**
	 * The constructor for the class.
	 * @param iRequestor The  requestor that the player uses to request moves of the board.
	 * @param player The player number of this player.
	 * @SBGen Constructor assigns iRequestor, player
	 */
	public APlayer(IRequestor iRequestor, int player)
	{
		// SBgen: Assign variables
		this.iRequestor = iRequestor;
		this.player = player;
		// SBgen: End assign
	}


	/**
	 * Tells this player to take its turn.
	 */
	public abstract void takeTurn();

	/**
	 * Accessor method for the installed requestor.
	 * @return 
	 * @SBGen Method get iRequestor
	 */
	public IRequestor getRequestor()
	{
		// SBgen: Get variable
		return(iRequestor);
	}

	/**
	 * Accessor method for this player's number.
	 * @return 
	 * @SBGen Method get player
	 */
	public int getPlayer()
	{
		// SBgen: Get variable
		return(player);
	}


	/**
	 * Accessor method for the player whose turn is after this player's.
	 * @return 
	 * @SBGen Method get nextPlayer
	 */
	public APlayer getNextPlayer()
	{
		// SBgen: Get variable
		return(nextPlayer);
	}

	/**
	 * Accessor method for the player whose turn is after this player's.
	 * @param nextPlayer 
	 * @SBGen Method set nextPlayer
	 */
	private void setNextPlayer(APlayer nextPlayer)
	{
		// SBgen: Assign variable
		this.nextPlayer = nextPlayer;
	}

	/**
	 * Inserts the given player as the player whose turn is next.   The current next player will become the supplied player's next player.
	 * @param player 
	 */
	public void insertAsRest(APlayer player)
	{
          player.setNextPlayer(getNextPlayer());
          setNextPlayer(player);
	}
}

