/* Generated by Together */

package view;

import java.util.*;

/**
 * Administrative interface for the model.
 */
public interface IModelAdmin
{
    /**
	 * Resets the model to its startup defaults.
	 */
	public abstract void reset();

    /**
	 * Halts the game after the current turn is completed.
	 */
	public abstract void exit();

    /**
	 * Returns a list of Objects that the view can use for selecting which type of player to be used.  The toString() methods of the Objects in the Vector will return a String description of the type of player.
	 * @return
	 */
	public abstract Vector getPlayers();

	/**
	 * Used by the view's adapter to inform the model which players were selected from the set of possible players supplied by the getPlayers() method.
	 * @param player1 The player that plays first.
	 * @param player2 The player that plays second.
	 */
	public abstract void setPlayers(Object player1, Object player2);

        /**
	 * Creates a factory that can the model can use to instantiate a new ComputerPlayer, given the class name of the required INextMoveStrategy.
	 * @param className The fully qualified class name of the INextMoveStrategy to use.
	 * @return 
	 */
	public abstract Object addPlayer(String className);
}
