/*
 * Decompiled with CFR 0.152.
 */
package controller;

import GameIO.IViewRequestor;
import java.util.Vector;
import model.GameModel;
import model.IBoardModel;
import model.ITurnAdmin;
import model.IViewAdmin;
import view.IModelAdmin;
import view.TicTacToeFrame;

public class GameController {
    public void run(IBoardModel boardModel, int maxTurnTime) {
        final TicTacToeFrame view = new TicTacToeFrame();
        final GameModel model = new GameModel(boardModel, maxTurnTime);
        view.setDimension(model.getBoardModel().getDimension());
        model.setCommand(view.getCommand());
        model.setViewAdmin(new IViewAdmin(){

            public void draw() {
                view.draw();
            }

            public void win(int player) {
                view.win(player);
            }

            public void reset() {
                view.reset();
            }
        }, new ITurnAdmin(){

            public void takeTurn(IViewRequestor requestor) {
                view.setRequestor(requestor);
                view.enableBtns(true);
            }
        });
        view.setModelAdmin(new IModelAdmin(){

            public void reset() {
                model.reset();
            }

            public void exit() {
                model.exit();
            }

            public Vector getPlayers() {
                return model.getPlayers();
            }

            public void setPlayers(Object player1, Object player2) {
                model.setPlayers(player1, player2);
            }

            public Object addPlayer(String className) {
                return model.addPlayer(className);
            }
        });
        view.resetAll();
    }
}

