/*
 * Decompiled with CFR 0.152.
 */
package model;

import GameIO.ICommand;
import GameIO.IRejectCommand;
import java.lang.reflect.Constructor;
import java.util.Vector;
import model.APlayer;
import model.ComputerPlayer;
import model.HumanPlayer;
import model.IBoardModel;
import model.IBoardStatusVisitor;
import model.ICheckMoveVisitor;
import model.IModel;
import model.INextMoveStrategy;
import model.IRequestor;
import model.ITurnAdmin;
import model.IViewAdmin;
import model.TurnControl;
import model.nextMove.AlphaBetaFac;
import model.nextMove.DepthFac;
import model.nextMove.MinMax;
import model.nextMove.MinMaxFac;
import model.nextMove.RandomMoveStrategy;
import model.nextMove.RandomValidMove;

public final class GameModel
implements IModel {
    private int maxTurnTime = 15;
    private TurnControl turnControl = TurnControl.NullObject;
    private ICommand iCommand;
    private IViewAdmin viewAdmin;
    private ITurnAdmin turnAdmin;
    private IBoardModel boardModel;
    private IRequestor requestor;

    public GameModel(IBoardModel boardModel, int maxTurnTime) {
        class Model_GameModel$1
        implements IRequestor {
            Model_GameModel$1() {
            }

            public void setTokenAt(int row, int col, int player, IRejectCommand rejectCommand) {
                GameModel.this.boardModel.makeMove(row, col, player, new ICheckMoveVisitor(this, rejectCommand){
                    private final /* synthetic */ IRejectCommand val$rejectCommand;
                    private final /* synthetic */ Model_GameModel$1 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$rejectCommand = val$rejectCommand;
                    }

                    public void invalidMoveCase() {
                        this.val$rejectCommand.execute();
                    }

                    public void validMoveCase() {
                        GameModel.access$0(Model_GameModel$1.access$1(this.this$1)).redrawAll(GameModel.access$2(Model_GameModel$1.access$1(this.this$1)));
                    }
                }, new IBoardStatusVisitor(this, player){
                    private final /* synthetic */ int val$player;
                    private final /* synthetic */ Model_GameModel$1 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$player = val$player;
                    }

                    public Object player0WonCase(IBoardModel host, Object param) {
                        GameModel.access$3(Model_GameModel$1.access$1(this.this$1)).setHalt();
                        GameModel.access$4(Model_GameModel$1.access$1(this.this$1)).win(0);
                        return null;
                    }

                    public Object player1WonCase(IBoardModel host, Object param) {
                        GameModel.access$3(Model_GameModel$1.access$1(this.this$1)).setHalt();
                        GameModel.access$4(Model_GameModel$1.access$1(this.this$1)).win(1);
                        return null;
                    }

                    public Object drawCase(IBoardModel host, Object param) {
                        GameModel.access$3(Model_GameModel$1.access$1(this.this$1)).setHalt();
                        GameModel.access$4(Model_GameModel$1.access$1(this.this$1)).draw();
                        return null;
                    }

                    public Object noWinnerCase(IBoardModel host, Object param) {
                        GameModel.access$3(Model_GameModel$1.access$1(this.this$1)).setSkipPlayer(GameModel.access$0(Model_GameModel$1.access$1(this.this$1)).isSkipPlayer(1 - this.val$player));
                        GameModel.access$3(Model_GameModel$1.access$1(this.this$1)).setProceed();
                        return null;
                    }
                });
            }

            static /* synthetic */ GameModel access$1(Model_GameModel$1 x$0) {
                return x$0.GameModel.this;
            }
        }
        this.requestor = new Model_GameModel$1();
        this.boardModel = boardModel;
        this.maxTurnTime = maxTurnTime;
    }

    public void setCommand(ICommand command) {
        this.iCommand = command;
    }

    public void reset() {
        System.out.println("Resetting");
        this.boardModel.reset();
        this.boardModel.redrawAll(this.iCommand);
        this.turnControl.setHalt();
    }

    public void setPlayers(Object player0, Object player1) {
        this.turnControl = new TurnControl(((IMakePlayer)player1).create(1));
        this.turnControl.addPlayer(((IMakePlayer)player0).create(0));
        this.turnControl.setAdapters(this.viewAdmin, this.iCommand);
        this.turnControl.run(this.maxTurnTime);
    }

    public void setViewAdmin(IViewAdmin viewAdmin, ITurnAdmin turnAdmin) {
        this.viewAdmin = viewAdmin;
        this.turnAdmin = turnAdmin;
    }

    public IBoardModel getBoardModel() {
        return this.boardModel;
    }

    public Vector getPlayers() {
        Vector<IMakePlayer> v = new Vector<IMakePlayer>();
        class Model_GameModel$4
        implements IMakePlayer {
            Model_GameModel$4() {
            }

            public APlayer create(int playerNo) {
                return new HumanPlayer(GameModel.this.requestor, playerNo, GameModel.this.turnAdmin);
            }

            public String toString() {
                return "Human player";
            }
        }
        v.addElement(new Model_GameModel$4());
        class Model_GameModel$5
        implements IMakePlayer {
            Model_GameModel$5() {
            }

            public APlayer create(int playerNo) {
                return new ComputerPlayer(GameModel.this.requestor, playerNo, GameModel.this, new RandomMoveStrategy());
            }

            public String toString() {
                return "Computer RandomMove";
            }
        }
        v.addElement(new Model_GameModel$5());
        class Model_GameModel$6
        implements IMakePlayer {
            Model_GameModel$6() {
            }

            public APlayer create(int playerNo) {
                return new ComputerPlayer(GameModel.this.requestor, playerNo, GameModel.this, new RandomValidMove());
            }

            public String toString() {
                return "Computer RandomValidMove";
            }
        }
        v.addElement(new Model_GameModel$6());
        class Model_GameModel$7
        implements IMakePlayer {
            Model_GameModel$7() {
            }

            public APlayer create(int playerNo) {
                return new ComputerPlayer(GameModel.this.requestor, playerNo, GameModel.this, new MinMax(new MinMaxFac()));
            }

            public String toString() {
                return "Computer w. MinMax";
            }
        }
        v.addElement(new Model_GameModel$7());
        class Model_GameModel$8
        implements IMakePlayer {
            Model_GameModel$8() {
            }

            public APlayer create(int playerNo) {
                return new ComputerPlayer(GameModel.this.requestor, playerNo, GameModel.this, new MinMax(new AlphaBetaFac()));
            }

            public String toString() {
                return "Computer w. AlphaBeta";
            }
        }
        v.addElement(new Model_GameModel$8());
        class Model_GameModel$9
        implements IMakePlayer {
            Model_GameModel$9() {
            }

            public APlayer create(int playerNo) {
                return new ComputerPlayer(GameModel.this.requestor, playerNo, GameModel.this, new MinMax(new DepthFac(new AlphaBetaFac(), 2)));
            }

            public String toString() {
                return "Computer w. Depth 2";
            }
        }
        v.addElement(new Model_GameModel$9());
        class Model_GameModel$10
        implements IMakePlayer {
            Model_GameModel$10() {
            }

            public APlayer create(int playerNo) {
                return new ComputerPlayer(GameModel.this.requestor, playerNo, GameModel.this, new MinMax(new DepthFac(new AlphaBetaFac(), 3)));
            }

            public String toString() {
                return "Computer w. Depth 3";
            }
        }
        v.addElement(new Model_GameModel$10());
        return v;
    }

    public void exit() {
        this.reset();
    }

    public Object addPlayer(String className) {
        INextMoveStrategy strategy;
        try {
            Constructor<?> c = Class.forName(className).getConstructors()[0];
            Object[][] args = new Object[][]{new Object[0], {this}};
            strategy = (INextMoveStrategy)c.newInstance(args[c.getParameterTypes().length]);
        }
        catch (Exception ex) {
            this.iCommand.setMessage(ex.toString());
            Object var4_5 = null;
            return var4_5;
        }
        this.iCommand.setMessage("");
        class Model_GameModel$11
        implements IMakePlayer {
            private final /* synthetic */ String val$className;
            private final /* synthetic */ INextMoveStrategy val$strategy;

            Model_GameModel$11(INextMoveStrategy val$strategy, String val$className) {
                this.val$strategy = val$strategy;
                this.val$className = val$className;
            }

            public APlayer create(int playerNo) {
                return new ComputerPlayer(GameModel.this.requestor, playerNo, GameModel.this, this.val$strategy);
            }

            public String toString() {
                return this.val$className;
            }
        }
        return new Model_GameModel$11(strategy, className);
    }

    public long getTimeLeft() {
        return this.turnControl.getTimeLeft();
    }

    static /* synthetic */ IViewAdmin access$4(GameModel x$0) {
        return x$0.viewAdmin;
    }

    static /* synthetic */ ICommand access$2(GameModel x$0) {
        return x$0.iCommand;
    }

    static /* synthetic */ TurnControl access$3(GameModel x$0) {
        return x$0.turnControl;
    }

    private static interface IMakePlayer {
        public APlayer create(int var1);
    }
}

