/*
 * Decompiled with CFR 0.152.
 */
package model;

import GameIO.ICommand;
import model.APlayer;
import model.IViewAdmin;

public class TurnControl {
    public static final TurnControl NullObject = new TurnControl(){

        public void setHalt() {
        }

        public void setProceed() {
        }
    };
    private APlayer players;
    private boolean skipPlayer = false;
    private boolean isFullHalt = false;
    private IViewAdmin viewAdmin;
    private ICommand iCommand;
    private ANextTurn proceedTurn = new ANextTurn(this){

        boolean apply() {
            System.out.println("Proceeding to next player...");
            TurnControl.this.players = TurnControl.this.players.getNextPlayer();
            if (TurnControl.this.skipPlayer) {
                TurnControl.this.skipPlayer = false;
                TurnControl.this.players = TurnControl.this.players.getNextPlayer();
            }
            TurnControl.this.setWait();
            TurnControl.this.restartCheckTime();
            TurnControl.this.players.takeTurn();
            return true;
        }
    };
    private ANextTurn waitTurn = new ANextTurn(this, this){

        boolean apply() {
            System.out.println("Waiting....");
            try {
                Thread.sleep(500L);
            }
            catch (Exception ex) {
                System.err.println(ex);
            }
            return true;
        }
    };
    private ANextTurn haltTurn = new ANextTurn(this, this){

        boolean apply() {
            System.out.println("Halting....");
            return false;
        }
    };
    private volatile ANextTurn nextTurn = this.proceedTurn;
    private long endTime;
    private long timeInterval = 10000L;
    private int timeCheckInterval = 10;
    private boolean isTimeThreadContinue = true;

    private TurnControl() {
    }

    public TurnControl(APlayer players) {
        this.players = players;
    }

    public void addPlayer(APlayer player) {
        this.players.insertAsRest(player);
        APlayer temp = this.players;
        int i = 1;
        do {
            System.out.print(String.valueOf(String.valueOf(new StringBuffer("player ").append(i).append(" = ").append(temp).append(" "))));
        } while (this.players != (temp = temp.getNextPlayer()));
        System.out.println("");
    }

    public void setAdapters(IViewAdmin viewAdmin, ICommand iCommand) {
        this.viewAdmin = viewAdmin;
        this.iCommand = iCommand;
    }

    public void run(int maxTurnTime) {
        this.timeInterval = 1000 * maxTurnTime;
        this.isFullHalt = false;
        this.nextTurn = this.proceedTurn;
        this.runCheckTime();
        new Thread(){

            public void run() {
                try {
                    while (TurnControl.this.nextTurn.apply()) {
                        if (!TurnControl.this.isFullHalt) continue;
                        System.out.println("TurnControll.run():  Full halt.");
                        break;
                    }
                }
                catch (Exception e) {
                    System.out.println("TurnControl.run() exception: ".concat(String.valueOf(String.valueOf(e))));
                }
            }
        }.start();
    }

    public synchronized void setProceed() {
        this.pauseCheckTime();
        this.nextTurn = this.proceedTurn;
    }

    public synchronized void setWait() {
        this.nextTurn = this.waitTurn;
    }

    public synchronized void setHalt() {
        this.nextTurn = this.haltTurn;
        this.isTimeThreadContinue = false;
    }

    public synchronized void setFullHalt() {
        this.isFullHalt = true;
        this.setHalt();
    }

    public synchronized void setSkipPlayer(boolean skipPlayer) {
        this.skipPlayer = skipPlayer;
    }

    private void setTimeInterval(long timeInterval) {
        this.timeInterval = timeInterval;
    }

    public long getTimeLeft() {
        return this.endTime - System.currentTimeMillis();
    }

    private void restartCheckTime() {
        this.endTime = System.currentTimeMillis() + this.timeInterval;
    }

    private void pauseCheckTime() {
        System.out.println(String.valueOf(String.valueOf(new StringBuffer("Player #").append(this.players.getPlayer()).append(" used ").append((double)(this.timeInterval - this.getTimeLeft()) / 1000.0).append(" secs."))));
        this.endTime = Long.MAX_VALUE;
    }

    private void runCheckTime() {
        this.isTimeThreadContinue = true;
        this.pauseCheckTime();
        new Thread(){

            public void run() {
                while (TurnControl.this.isTimeThreadContinue) {
                    TurnControl.this.iCommand.setMessage(String.valueOf(String.valueOf(new StringBuffer("Time left for player #").append(TurnControl.this.players.getPlayer()).append("= ").append((double)TurnControl.this.getTimeLeft() / 1000.0))));
                    if (TurnControl.this.getTimeLeft() < (long)0) {
                        TurnControl.this.setFullHalt();
                        TurnControl.this.iCommand.setMessage(String.valueOf(String.valueOf(new StringBuffer("Player #").append(TurnControl.this.players.getPlayer()).append(" has exceeded their allotted time!"))));
                        TurnControl.this.viewAdmin.win(TurnControl.this.players.getNextPlayer().getPlayer());
                        break;
                    }
                    try {
                        Thread.sleep(TurnControl.this.timeCheckInterval);
                    }
                    catch (Exception ex) {
                        System.out.println("TurnControl.runCheckTime:".concat(String.valueOf(String.valueOf(ex.getMessage()))));
                        break;
                    }
                }
            }
        }.start();
    }

    abstract class ANextTurn {
        ANextTurn(TurnControl this$0) {
        }

        abstract boolean apply();
    }
}

