/*
 * Decompiled with CFR 0.152.
 */
package model.board;

import GameIO.ICommand;
import java.awt.Dimension;
import model.IBoardLambda;
import model.IBoardModel;
import model.IBoardStatusVisitor;
import model.ICheckMoveVisitor;
import model.IUndoMove;
import model.board.ABoardState;
import model.board.DrawState;
import model.board.NonTerminalState;

public abstract class ABoardModel
implements IBoardModel {
    protected static final int EMPTY = 0;
    protected int[][] cells;
    protected ABoardState state = DrawState.Singleton;
    protected int[][] directions = new int[][]{{1, 0}, {0, 1}, {1, 1}, {1, -1}};

    public ABoardModel(int nRows, int nCols) {
        this.cells = new int[nRows][nCols];
    }

    public int valueToPlayer(int value) {
        return (value + 1) / 2;
    }

    public int playerToValue(int player) {
        return 2 * player - 1;
    }

    public Dimension getDimension() {
        return new Dimension(this.cells[0].length, this.cells.length);
    }

    public abstract IUndoMove makeMove(int var1, int var2, int var3, ICheckMoveVisitor var4, IBoardStatusVisitor var5);

    public void reset() {
        this.mapAll(0, new IBoardLambda(){

            public boolean apply(int player, IBoardModel host, Object param, int row, int col, int value) {
                ABoardModel.this.cells[row][col] = 0;
                return true;
            }

            public void noApply(int player, IBoardModel host, Object param) {
            }
        }, null);
        this.state = NonTerminalState.Singleton;
    }

    int[][] getCells() {
        return this.cells;
    }

    public void map(int player, IBoardLambda lambda, Object param) {
        this.state.map(player, lambda, param, this);
    }

    public void mapAll(int player, IBoardLambda lambda, Object param) {
        int[][] idx = this.randomizeIdx(this.cells.length, this.cells[0].length);
        for (int i = 0; i < idx.length; ++i) {
            if (lambda.apply(player, this, param, idx[i][0], idx[i][1], this.cells[idx[i][0]][idx[i][1]])) continue;
            return;
        }
    }

    public int playerAt(int row, int col) {
        return this.cells[row][col];
    }

    public Object execute(IBoardStatusVisitor visitor, Object param) {
        return this.state.execute(visitor, param, this);
    }

    protected abstract boolean isValidMove(int var1, int var2, int var3);

    public void redrawAll(final ICommand command) {
        this.mapAll(0, new IBoardLambda(){

            public boolean apply(int player, IBoardModel host, Object param, int row, int col, int value) {
                value = ABoardModel.this.cells[row][col];
                if (value == 0) {
                    command.clearTokenAt(row, col);
                } else {
                    command.setTokenAt(row, col, ABoardModel.this.valueToPlayer(value));
                }
                return true;
            }

            public void noApply(int player, IBoardModel host, Object param) {
                throw new IllegalStateException("ABoardModel.redrawAll(): noApply() should be unreachable!");
            }
        }, null);
    }

    public boolean isSkipPlayer(int player) {
        final boolean[] result = new boolean[]{false};
        this.map(player, new IBoardLambda(){

            public boolean apply(int player, IBoardModel host, Object param, int row, int col, int value) {
                return false;
            }

            public void noApply(int player, IBoardModel host, Object param) {
                result[0] = true;
            }
        }, null);
        return result[0];
    }

    final int[][] randomizeIdx(int nRows, int nCols) {
        int i;
        int[][] idx = new int[nRows * nCols][2];
        for (i = 0; i < nRows; ++i) {
            for (int j = 0; j < nCols; ++j) {
                idx[i * nCols + j][0] = i;
                idx[i * nCols + j][1] = j;
            }
        }
        for (i = 0; i < idx.length; ++i) {
            int[] temp = idx[i];
            int j = (int)((double)idx.length * Math.random());
            idx[i] = idx[j];
            idx[j] = temp;
        }
        return idx;
    }

    static {
        EMPTY = 0;
    }
}

