/*
 * Decompiled with CFR 0.152.
 */
package model.board;

import model.IBoardLambda;
import model.IBoardStatusVisitor;
import model.board.ABoardModel;
import model.board.ABoardState;

class NonTerminalState
extends ABoardState {
    public static NonTerminalState Singleton = new NonTerminalState();

    protected NonTerminalState() {
    }

    public void map(int player, IBoardLambda lambda, Object param, ABoardModel host) {
        boolean noApply = true;
        int[][] cells = host.getCells();
        int[][] idx = host.randomizeIdx(cells.length, cells[0].length);
        for (int i = 0; i < idx.length; ++i) {
            if (!host.isValidMove(player, idx[i][0], idx[i][1])) continue;
            noApply = false;
            if (lambda.apply(player, host, param, idx[i][0], idx[i][1], cells[idx[i][0]][idx[i][1]])) continue;
            return;
        }
        if (noApply) {
            lambda.noApply(player, host, param);
        }
    }

    public Object execute(IBoardStatusVisitor visitor, Object param, ABoardModel host) {
        return visitor.noWinnerCase(host, param);
    }
}

