/*
 * Decompiled with CFR 0.152.
 */
package model.board;

import java.util.Vector;
import model.IBoardLambda;
import model.IBoardModel;
import model.IBoardStatusVisitor;
import model.ICheckMoveVisitor;
import model.IUndoMove;
import model.IUndoVisitor;
import model.board.ABoardModel;
import model.board.DrawState;
import model.board.NonTerminalState;
import model.board.Player0WonState;
import model.board.Player1WonState;

public class OthelloBoard
extends ABoardModel {
    public OthelloBoard(int nRows, int nCols) {
        super(nRows, nCols);
    }

    private synchronized int checkWin(final int player0) {
        final int[] totals = new int[]{0, 0};
        final int[] winner = new int[]{0};
        this.map(this.valueToPlayer(-this.playerToValue(player0)), new IBoardLambda(){

            public boolean apply(int player, IBoardModel host, Object param, int row, int col, int value) {
                OthelloBoard.this.state = NonTerminalState.Singleton;
                return false;
            }

            public void noApply(int player, IBoardModel host, Object param) {
                OthelloBoard.this.map(player0, new IBoardLambda(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public boolean apply(int player, IBoardModel host, Object param, int row, int col, int value) {
                        1.access$0(this.this$1).state = NonTerminalState.Singleton;
                        return false;
                    }

                    public void noApply(int player, IBoardModel host, Object param) {
                        1.access$1(this.this$1)[0] = OthelloBoard.access$2(1.access$0(this.this$1), 1.access$3(this.this$1));
                        switch (1.access$1(this.this$1)[0]) {
                            case 0: {
                                1.access$0(this.this$1).state = DrawState.Singleton;
                                break;
                            }
                            case 1: {
                                1.access$0(this.this$1).state = Player1WonState.Singleton;
                                break;
                            }
                            case -1: {
                                1.access$0(this.this$1).state = Player0WonState.Singleton;
                                break;
                            }
                        }
                    }
                }, null);
            }

            static /* synthetic */ OthelloBoard access$0(1 x$0) {
                return x$0.OthelloBoard.this;
            }

            static /* synthetic */ int[] access$1(1 x$0) {
                return x$0.winner;
            }

            static /* synthetic */ int[] access$3(1 x$0) {
                return x$0.totals;
            }
        }, null);
        return winner[0];
    }

    public synchronized IUndoMove makeMove(final int row, final int col, final int player, ICheckMoveVisitor chkMoveVisitor, IBoardStatusVisitor statusVisitor) {
        if (this.isValidMove(player, row, col)) {
            final Vector flipped = this.flipAll(row, col, player);
            this.checkWin(player);
            chkMoveVisitor.validMoveCase();
            this.execute(statusVisitor, null);
            return new IUndoMove(){

                public void apply(IUndoVisitor undoVisitor) {
                    OthelloBoard.this.undoMove(player, row, col, undoVisitor, flipped);
                }
            };
        }
        chkMoveVisitor.invalidMoveCase();
        return new IUndoMove(){

            public void apply(IUndoVisitor undoVisitor) {
            }
        };
    }

    private final synchronized void undoMove(int player, int row, int col, IUndoVisitor undoVisitor, Vector flipped) {
        int value = this.cells[row][col];
        if (value == 0) {
            undoVisitor.noTokenCase();
        } else {
            this.cells[row][col] = 0;
            undoVisitor.tokenCase((value + 1) / 2);
        }
        for (int i = 0; i < flipped.size(); ++i) {
            int[] rc = (int[])flipped.elementAt(i);
            this.cells[rc[0]][rc[1]] = -this.playerToValue(player);
        }
        this.state = NonTerminalState.Singleton;
    }

    public synchronized void reset() {
        super.reset();
        int r = this.cells.length / 2;
        int c = this.cells[0].length / 2;
        this.cells[r][c] = this.playerToValue(1);
        this.cells[r - 1][c] = this.playerToValue(0);
        this.cells[r][c - 1] = this.playerToValue(0);
        this.cells[r - 1][c - 1] = this.playerToValue(1);
    }

    protected boolean isValidMove(int player, int row, int col) {
        if (this.cells[row][col] == 0) {
            for (int i = 0; i < this.directions.length; ++i) {
                int vr = this.directions[i][0];
                int vc = this.directions[i][1];
                if (!this.isValidMove1(player, row + vr, col + vc, vr, vc, row - vr, col - vc)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean isValidMove1(int player, int row0, int col0, int vRow, int vCol, int row1, int col1) {
        if (row0 < 0 || col0 < 0 || row0 >= this.cells.length || col0 >= this.cells[row0].length) {
            return this.isValidMove2(player, row1, col1, -vRow, -vCol);
        }
        if (this.cells[row0][col0] == this.playerToValue(player) || this.cells[row0][col0] == 0) {
            return this.isValidMove2(player, row1, col1, -vRow, -vCol);
        }
        return this.isValidMove1a(player, row0 + vRow, col0 + vCol, vRow, vCol, row1, col1);
    }

    private boolean isValidMove1a(int player, int row0, int col0, int vRow, int vCol, int row1, int col1) {
        if (row0 < 0 || col0 < 0 || row0 >= this.cells.length || col0 >= this.cells[row0].length) {
            return this.isValidMove2(player, row1, col1, -vRow, -vCol);
        }
        if (this.cells[row0][col0] == 0) {
            return this.isValidMove2(player, row1, col1, -vRow, -vCol);
        }
        if (this.cells[row0][col0] == this.playerToValue(player)) {
            return true;
        }
        return this.isValidMove1a(player, row0 + vRow, col0 + vCol, vRow, vCol, row1, col1);
    }

    private boolean isValidMove2(int player, int row0, int col0, int vRow, int vCol) {
        if (row0 < 0 || col0 < 0 || row0 >= this.cells.length || col0 >= this.cells[row0].length) {
            return false;
        }
        if (this.cells[row0][col0] == this.playerToValue(player) || this.cells[row0][col0] == 0) {
            return false;
        }
        return this.isValidMove2a(player, row0 + vRow, col0 + vCol, vRow, vCol);
    }

    private boolean isValidMove2a(int player, int row0, int col0, int vRow, int vCol) {
        if (row0 < 0 || col0 < 0 || row0 >= this.cells.length || col0 >= this.cells[row0].length) {
            return false;
        }
        if (this.cells[row0][col0] == 0) {
            return false;
        }
        if (this.cells[row0][col0] == this.playerToValue(player)) {
            return true;
        }
        return this.isValidMove2a(player, row0 + vRow, col0 + vCol, vRow, vCol);
    }

    private Vector flipAll(int row, int col, int player) {
        Vector flipped = new Vector();
        this.cells[row][col] = this.playerToValue(player);
        for (int i = 0; i < this.directions.length; ++i) {
            int vr = this.directions[i][0];
            int vc = this.directions[i][1];
            this.flip(player, row + vr, col + vc, vr, vc, flipped);
            this.flip(player, row - vr, col - vc, -vr, -vc, flipped);
        }
        return flipped;
    }

    private void flip(int player, int row0, int col0, int vRow, int vCol, Vector flipped) {
        if (row0 < 0 || col0 < 0 || row0 >= this.cells.length || col0 >= this.cells[row0].length) {
            return;
        }
        if (this.cells[row0][col0] == this.playerToValue(player) || this.cells[row0][col0] == 0) {
            return;
        }
        if (this.flip_h(player, row0 + vRow, col0 + vCol, vRow, vCol, flipped)) {
            this.cells[row0][col0] = this.playerToValue(player);
            flipped.addElement(new int[]{row0, col0});
        }
    }

    private boolean flip_h(int player, int row0, int col0, int vRow, int vCol, Vector flipped) {
        if (row0 < 0 || col0 < 0 || row0 >= this.cells.length || col0 >= this.cells[row0].length) {
            return false;
        }
        if (this.cells[row0][col0] == 0) {
            return false;
        }
        if (this.cells[row0][col0] == this.playerToValue(player)) {
            return true;
        }
        if (this.flip_h(player, row0 + vRow, col0 + vCol, vRow, vCol, flipped)) {
            this.cells[row0][col0] = this.playerToValue(player);
            flipped.addElement(new int[]{row0, col0});
            return true;
        }
        return false;
    }

    private int countTokens(final int[] totals) {
        this.mapAll(0, new IBoardLambda(){

            public boolean apply(int player, IBoardModel host, Object param, int row, int col, int value) {
                if (OthelloBoard.this.cells[row][col] != 0) {
                    int n = OthelloBoard.this.valueToPlayer(OthelloBoard.this.cells[row][col]);
                    totals[n] = totals[n] + 1;
                }
                return true;
            }

            public void noApply(int player, IBoardModel host, Object param) {
            }
        }, null);
        if (totals[0] > totals[1]) {
            return -1;
        }
        if (totals[1] > totals[0]) {
            return 1;
        }
        return 0;
    }

    static /* synthetic */ int access$2(OthelloBoard x$0, int[] x$1) {
        return x$0.countTokens(x$1);
    }
}

