/*
 * Decompiled with CFR 0.152.
 */
package view;

import GameIO.ICommand;
import GameIO.IRejectCommand;
import GameIO.IViewRequestor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import view.GameOverDialog;
import view.IModelAdmin;
import view.IView;

public class TicTacToeFrame
extends JFrame
implements IView {
    private JPanel contentPane;
    private BorderLayout borderLayout1 = new BorderLayout();
    private JPanel jPanel1 = new JPanel();
    private JButton resetBtn = new JButton("Reset");
    private JPanel jPanel2 = new JPanel();
    private GridLayout gridLayout1 = new GridLayout();
    private GridLayout gridLayout2 = new GridLayout();
    private JPanel jPanel3 = new JPanel();
    private ButtonGroup buttonGroup1 = new ButtonGroup();
    private GridLayout gridLayout3 = new GridLayout();
    private JButton startBtn = new JButton("Start");
    private JLabel jLabel1 = new JLabel("Starting player (X):");
    private JButton[][] btnArray;
    private String[] symbolStr = new String[]{"X", "0"};
    private IModelAdmin modelAdmin;
    private IViewRequestor requestor;
    private JLabel statusLbl = new JLabel(" Remaining time:");
    private JComboBox player1CBx = new JComboBox();
    private JLabel jLabel2 = new JLabel("Second player (O):");
    private JComboBox player2CBx = new JComboBox();
    private JPanel jPanel4 = new JPanel();
    private JPanel jPanel5 = new JPanel();
    private GridLayout gridLayout4 = new GridLayout();
    private JLabel jLabel3 = new JLabel("Add player");
    private JTextField addPlayerTF = new JTextField("comp212prof.SBW_DXN_strategy2");

    public TicTacToeFrame() {
        this.enableEvents(64L);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        ((Component)this).setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
        ((Component)this).setVisible(true);
    }

    public ICommand getCommand() {
        return new ICommand(){

            public void setTokenAt(int row, int col, int player) {
                TicTacToeFrame.this.btnArray[row][col].setText(TicTacToeFrame.this.symbolStr[player]);
                TicTacToeFrame.this.statusLbl.setText(" ");
            }

            public void clearTokenAt(int row, int col) {
                TicTacToeFrame.this.btnArray[row][col].setText(" ");
            }

            public void setMessage(String s) {
                TicTacToeFrame.this.statusLbl.setText(s);
            }
        };
    }

    private void jbInit() throws Exception {
        this.contentPane = (JPanel)this.getContentPane();
        this.contentPane.setLayout(this.borderLayout1);
        ((Component)this).setSize(new Dimension(1059, 471));
        this.setTitle("Frame Title");
        this.resetBtn.setEnabled(false);
        this.resetBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TicTacToeFrame.this.resetBtn_actionPerformed(e);
            }
        });
        this.jPanel2.setLayout(this.gridLayout1);
        this.jPanel2.setBackground(Color.black);
        this.jPanel1.setLayout(this.gridLayout2);
        this.gridLayout2.setRows(-1);
        this.gridLayout2.setColumns(1);
        this.gridLayout2.setHgap(10);
        this.gridLayout2.setVgap(5);
        this.jPanel3.setLayout(this.gridLayout3);
        this.gridLayout3.setRows(-1);
        this.gridLayout3.setColumns(1);
        this.startBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TicTacToeFrame.this.startBtn_actionPerformed(e);
            }
        });
        this.borderLayout1.setHgap(20);
        this.borderLayout1.setVgap(20);
        this.statusLbl.setPreferredSize(new Dimension(3, 20));
        this.jPanel4.setLayout(this.gridLayout4);
        this.gridLayout4.setRows(2);
        this.gridLayout4.setColumns(1);
        this.addPlayerTF.setPreferredSize(new Dimension(500, 21));
        this.addPlayerTF.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TicTacToeFrame.this.addPlayerTF_actionPerformed(e);
            }
        });
        this.contentPane.add((Component)this.jPanel1, "West");
        this.contentPane.add((Component)this.jPanel5, "North");
        this.jPanel5.add((Component)this.jLabel3, null);
        this.jPanel5.add((Component)this.addPlayerTF, null);
        this.jPanel1.add((Component)this.jPanel4, null);
        this.jPanel4.add((Component)this.resetBtn, null);
        this.jPanel4.add((Component)this.startBtn, null);
        this.jPanel1.add((Component)this.jPanel3, null);
        this.jPanel3.add((Component)this.jLabel1, null);
        this.jPanel3.add((Component)this.player1CBx, null);
        this.jPanel3.add((Component)this.jLabel2, null);
        this.jPanel3.add((Component)this.player2CBx, null);
        this.contentPane.add((Component)this.jPanel2, "Center");
        this.contentPane.add((Component)this.statusLbl, "South");
    }

    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 201) {
            this.exit();
        }
    }

    public void exit() {
        this.dispose();
        this.modelAdmin.exit();
    }

    public void reset() {
        this.clearBtns();
        this.enableBtns(false);
        this.resetBtn.setEnabled(false);
        this.startBtn.setEnabled(true);
        this.statusLbl.setText("");
    }

    void clearBtns() {
        for (int i = 0; i < this.btnArray.length; ++i) {
            for (int j = 0; j < this.btnArray[i].length; ++j) {
                this.btnArray[i][j].setText("");
            }
        }
    }

    public void enableBtns(boolean state) {
        for (int i = 0; i < this.btnArray.length; ++i) {
            for (int j = 0; j < this.btnArray[i].length; ++j) {
                this.btnArray[i][j].setEnabled(state);
            }
        }
    }

    public void resetAll() {
        this.reset();
        this.modelAdmin.reset();
    }

    private void resetBtn_actionPerformed(ActionEvent e) {
        this.resetAll();
    }

    public void setRequestor(IViewRequestor requestor) {
        this.requestor = requestor;
    }

    private void startBtn_actionPerformed(ActionEvent e) {
        this.startBtn.setEnabled(false);
        this.resetBtn.setEnabled(true);
        this.modelAdmin.setPlayers(this.player1CBx.getSelectedItem(), this.player2CBx.getSelectedItem());
    }

    public void draw() {
        new GameOverDialog(this).draw();
    }

    public void setModelAdmin(IModelAdmin modelAdmin) {
        this.modelAdmin = modelAdmin;
        this.setPlayers(modelAdmin.getPlayers());
    }

    public void win(int player) {
        new GameOverDialog(this).playerWon(String.valueOf(String.valueOf(new StringBuffer("Player \"").append(this.symbolStr[player]).append("\""))));
    }

    public void setPlayers(Vector players) {
        for (int i = 0; i < players.size(); ++i) {
            this.player1CBx.addItem(players.elementAt(i));
            this.player2CBx.addItem(players.elementAt(i));
        }
    }

    public void setDimension(Dimension size) {
        int nRows = size.height;
        int nCols = size.width;
        this.gridLayout1.setRows(nRows);
        this.gridLayout1.setColumns(nCols);
        this.gridLayout1.setHgap(5);
        this.gridLayout1.setVgap(5);
        this.btnArray = new JButton[nRows][nCols];
        for (int row = 0; row < nRows; ++row) {
            int col = 0;
            while (col < nCols) {
                this.btnArray[row][col] = new JButton();
                final int thisRow = row;
                final int thisCol = col++;
                this.btnArray[thisRow][thisCol].addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        TicTacToeFrame.this.enableBtns(false);
                        TicTacToeFrame.this.requestor.setTokenAt(thisRow, thisCol, new IRejectCommand(this){
                            private final /* synthetic */ 5 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            public void execute() {
                                TicTacToeFrame.access$2(5.access$7(this.this$1)).setText(String.valueOf(String.valueOf(new StringBuffer("There is already an ").append(TicTacToeFrame.access$0(5.access$7(this.this$1))[5.access$8(this.this$1)][5.access$9(this.this$1)].getText()).append(" at (").append(5.access$8(this.this$1)).append(",").append(5.access$9(this.this$1)).append(")!"))));
                            }
                        });
                    }

                    static /* synthetic */ TicTacToeFrame access$7(5 x$0) {
                        return x$0.TicTacToeFrame.this;
                    }

                    static /* synthetic */ int access$8(5 x$0) {
                        return x$0.thisRow;
                    }

                    static /* synthetic */ int access$9(5 x$0) {
                        return x$0.thisCol;
                    }
                });
                this.btnArray[thisRow][thisCol].setBackground(Color.cyan);
                this.btnArray[thisRow][thisCol].setFont(new Font("Dialog", 1, 50));
                this.jPanel2.add((Component)this.btnArray[thisRow][thisCol], null);
            }
        }
        this.validate();
    }

    private void addPlayerTF_actionPerformed(ActionEvent e) {
        Object newPlayer = this.modelAdmin.addPlayer(this.addPlayerTF.getText());
        if (newPlayer != null) {
            this.player1CBx.addItem(newPlayer);
            this.player2CBx.addItem(newPlayer);
        }
        this.addPlayerTF.setText("");
    }
}

