/*
 * Decompiled with CFR 0.152.
 */
package model.board;

import model.IBoardLambda;
import model.IBoardModel;
import model.IBoardStatusVisitor;
import model.ICheckMoveVisitor;
import model.IUndoMove;
import model.IUndoVisitor;
import model.board.ABoardModel;
import model.board.DrawState;
import model.board.NonTerminalState;
import model.board.Player0WonState;
import model.board.Player1WonState;

public class TicTacToeBoard
extends ABoardModel {
    private int IN_ROW = 3;

    public TicTacToeBoard(int nRows, int nCols, int in_row) {
        super(nRows, nCols);
        this.IN_ROW = in_row;
    }

    private synchronized void chgState(int winner) {
        if (winner == -1) {
            this.state = Player0WonState.Singleton;
        } else if (winner == 1) {
            this.state = Player1WonState.Singleton;
        } else {
            this.map(winner, new IBoardLambda(){

                public boolean apply(int player, IBoardModel host, Object param, int row, int col, int value) {
                    TicTacToeBoard.this.state = NonTerminalState.Singleton;
                    return false;
                }

                public void noApply(int player, IBoardModel host, Object param) {
                    TicTacToeBoard.this.state = DrawState.Singleton;
                }
            }, null);
        }
    }

    public synchronized IUndoMove makeMove(final int row, final int col, int player, ICheckMoveVisitor chkMoveVisitor, IBoardStatusVisitor statusVisitor) {
        if (this.isValidMove(player, row, col)) {
            this.cells[row][col] = this.playerToValue(player);
            this.chgState(this.winCheck(row, col));
            chkMoveVisitor.validMoveCase();
            this.execute(statusVisitor, null);
            return new IUndoMove(){

                public void apply(IUndoVisitor undoVisitor) {
                    TicTacToeBoard.this.undoMove(row, col, undoVisitor);
                }
            };
        }
        chkMoveVisitor.invalidMoveCase();
        return new IUndoMove(){

            public void apply(IUndoVisitor undoVisitor) {
            }
        };
    }

    private synchronized void undoMove(int row, int col, IUndoVisitor undoVisitor) {
        int value = this.cells[row][col];
        if (value == 0) {
            undoVisitor.noTokenCase();
        } else {
            this.cells[row][col] = 0;
            undoVisitor.tokenCase((value + 1) / 2);
        }
        this.state = NonTerminalState.Singleton;
    }

    private int winCheck(int row, int col) {
        int player = this.cells[row][col];
        if (player != 0) {
            for (int i = 0; i < this.directions.length; ++i) {
                int vr = this.directions[i][0];
                int vc = this.directions[i][1];
                if (!this.winCheckHelp1(player, this.IN_ROW - 2, row + vr, col + vc, vr, vc, row - vr, col - vc)) continue;
                return player;
            }
        }
        return 0;
    }

    private final boolean winCheckHelp1(int player, int count, int row0, int col0, int vRow, int vCol, int row1, int col1) {
        if (row0 < 0 || col0 < 0 || row0 >= this.cells.length || col0 >= this.cells[row0].length) {
            return this.winCheckHelp2(player, count, row1, col1, -vRow, -vCol);
        }
        if (this.cells[row0][col0] != player) {
            return this.winCheckHelp2(player, count, row1, col1, -vRow, -vCol);
        }
        if (count == 0) {
            return true;
        }
        return this.winCheckHelp1(player, --count, row0 + vRow, col0 + vCol, vRow, vCol, row1, col1);
    }

    private final boolean winCheckHelp2(int player, int count, int row0, int col0, int vRow, int vCol) {
        if (row0 < 0 || col0 < 0 || row0 >= this.cells.length || col0 >= this.cells[row0].length || this.cells[row0][col0] != player) {
            return false;
        }
        if (count == 0) {
            return true;
        }
        return this.winCheckHelp2(player, --count, row0 + vRow, col0 + vCol, vRow, vCol);
    }

    protected boolean isValidMove(int player, int row, int col) {
        return this.cells[row][col] == 0;
    }
}

