package controller;

import java.awt.*;
import javax.swing.*;
import java.awt.event.*;
import model.board.*;

public class InitFrame extends JFrame {
    JPanel jPanel1 = new JPanel();
    JTextField nRowsTF = new JTextField("8");
    JTextField nColsTF = new JTextField("8");
    JButton makeTTTBtn = new JButton("Make TicTacToe!");
    JPanel jPanel2 = new JPanel();
    JButton othelloBtn = new JButton("Make Othello!");
    JTextField inRowTF = new JTextField("3");
    JLabel jLabel1 = new JLabel("in-arow");
    JLabel jLabel2 = new JLabel("rows, cols:");

    private boolean isApplet = false;
    JLabel jLabel3 = new JLabel("Max. turn time (s):");
    JTextField maxTurnTimeTF = new JTextField("60");

    public InitFrame(boolean isApplet) {
        this.isApplet = isApplet;
        try  {
            jbInit();
        }
        catch(Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception  {
        this.setSize(new Dimension(560, 188));
        nRowsTF.setPreferredSize(new Dimension(50, 21));
        nColsTF.setPreferredSize(new Dimension(50, 21));

        makeTTTBtn.addActionListener(new java.awt.event.ActionListener()  {
            public void actionPerformed(ActionEvent e) {
                makeTTTBtn_actionPerformed(e);
            }
        });

        othelloBtn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                othelloBtn_actionPerformed(e);
            }
        });

        inRowTF.setMinimumSize(new Dimension(10, 21));
        inRowTF.setPreferredSize(new Dimension(20, 21));

/*
        inRowTF.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                inRowTF_actionPerformed(e);
            }
        });
*/
        maxTurnTimeTF.setPreferredSize(new Dimension(30, 21));
        this.getContentPane().add(jPanel1, BorderLayout.NORTH);
        jPanel1.add(jLabel2, null);
        jPanel1.add(nRowsTF, null);
        jPanel1.add(nColsTF, null);
        jPanel1.add(jLabel3, null);
        jPanel1.add(maxTurnTimeTF, null);
        this.getContentPane().add(jPanel2, BorderLayout.SOUTH);
        jPanel2.add(othelloBtn, null);
        jPanel2.add(makeTTTBtn, null);
        jPanel2.add(inRowTF, null);
        jPanel2.add(jLabel1, null);
    }

    /** Overridden so we can exit when window is closed */
    protected void processWindowEvent(WindowEvent e)  {
        super.processWindowEvent(e);
        if (e.getID() == WindowEvent.WINDOW_CLOSING)  {
            exit();
        }
    }

    public void exit() {
        if(!isApplet) System.exit(0);
    }

    void makeTTTBtn_actionPerformed(ActionEvent e) {
        new GameController().run(new TicTacToeBoard(
                                        Integer.parseInt(nRowsTF.getText()),
                                        Integer.parseInt(nColsTF.getText()),
                                        Integer.parseInt(inRowTF.getText())),
                                    Integer.parseInt(maxTurnTimeTF.getText())
                                );
    }

/*
    void inRowTF_actionPerformed(ActionEvent e) {
    }
*/

    void othelloBtn_actionPerformed(ActionEvent e) {
        new GameController().run(new OthelloBoard(
                                      Integer.parseInt(nRowsTF.getText()),
                                      Integer.parseInt(nColsTF.getText())),
                                    Integer.parseInt(maxTurnTimeTF.getText())
                                );
    }
}