/**
 * Concrete implementation of the empty list interface, IEmptyList.
 * Since the empty list has no fields, there is no need to explicitly
 * define any constructor for EmptyList.
 * However, the compiler will generate the following constructor:
 * public EmptyList() {};
 * Note that there is no code inside the curly braces.
 * The above constructor has no parameter.  A constructor without any
 * parameter is called a "default" constructor.
 * To instantiate a concrete empty list, we simply call: new EmptyList();
 * @author Dung X. Nguyen
 * @since Copyright 2003 by DXN - All rights reserved
 */
public class EmptyList implements IEmptyList {

    /**
     * An empty list has no element.
     * @return 0.
     */
    public int getLength() {
         return 0;
    }

    /**
     * Concatenating an empty list with another list is simply the other list.
     * @param rhs the IList on the right hand side.
     * @return rhs
     */
    public IList concatenate(IList rhs) {
        return rhs;
    }

    /**
     * Returns "()".
     */
    public String toString() {
        return "()";
    }

    /**
     * For the case when this EmptyList is the rest of some list.
     * Simply returns the null String ""
     */
    public String toStringHelp() {
        return "";
    }
}