/**
 * Represents the abstract notion of a list.
 * At this point, it has no behavior, i.e. no method.
 * We shall add behaviors later.
 * @author Dung X. Nguyen
 * @since Copyright 2003 - DXN All rights reserved
 */
public interface IList {
    /**
     * Computes the number of elements in this IList.
     * @return an int >= 0.
     */
    public abstract int getLength();

    /**
     * Concatenates this IList with a given IList.
     * @param rhs the IList on the right hand side.
     * @return an IList consisting of elements of this IList followed by
     * elements of rhs.
     */
    public abstract IList concatenate(IList rhs);

    /**
     * Returns an appropriate String representation of this IList as the rest
     * of some other IList.
     * Called only when this IList is the rest of some other IList.
     */
    public abstract String toStringHelp();
}

