/**
 * Represents the immutable non-empty list, which is a list.
 * A non-empty list has a data object called first, and an
 * isomorphic subcomponent called rest.  Its structural behavior
 * provides access to its internal data (first) and substructure (rest).
 * @author Dung X. Nguyen
 * @since Copyright 2003 - DXN All rights reserved
 */
public interface INEList extends IList {
    /**
     * "Gettor" method for the list's first.
     * @return this INElist's first element.
     */
    public abstract Object getFirst();

    /**
     * "Gettor" method for the list's rest.
     * @return this INElist's rest.
     */
    public abstract IList getRest();
}

