import junit.framework.TestCase;

/**
 * Tesiing the IList hierarchy.
 * @author DXN
 * @since 01/25/04
 */
public class Test_List extends TestCase {
    
    private IList _e0 = new EmptyList();
    private IList _e1 = new NEList("one", _e0);
    private IList _e2 = new NEList("two", _e1);

    
    /**
     * _e0 = ()
     * _e1 = ("one")
     * _e2 = ("two" "one")
     * We test toString first and use it to test the other methods.
     */
    public void test_toString() {
        assertEquals("_e0: ", "()", _e0.toString());
        assertEquals("_e1: ", "(one)", _e1.toString());
        assertEquals("_e2: ", "(two one)", _e2.toString());
   }
    
    public void test_getLength() {
        assertEquals("_e0: ", 0, _e0.getLength());
        assertEquals("_e1: ", 1, _e1.getLength());
        assertEquals("_e2: ", 2, _e2.getLength());
   }

    public void test_concatenate() {
        assertEquals("_e0 + _e0: ", "()", _e0.concatenate(_e0).toString());
        assertEquals("_e0 + _e1: ", "(one)", _e0.concatenate(_e1).toString());
        assertEquals("_e1 + _e0: ", "(one)", _e1.concatenate(_e0).toString());
        assertEquals("_e0 + _e2: ", "(two one)", _e0.concatenate(_e2).toString());
        assertEquals("_e2 + _e0: ", "(two one)", _e2.concatenate(_e0).toString());
        assertEquals("_e1 + _e1: ", "(one one)", _e1.concatenate(_e1).toString());
        assertEquals("_e1 + _e2: ", "(one two one)", _e1.concatenate(_e2).toString());
        assertEquals("_e1 + _e2: ", "(one two one)", _e1.concatenate(_e2).toString());
        assertEquals("_e2 + _e2: ", "(two one two one)", _e2.concatenate(_e2).toString());
        assertEquals("_e2 + _e1: ", "(two one one)", _e2.concatenate(_e1).toString());
   }
}
