package controller;

import model.*;
import view.*;
import javax.swing.*;
import java.awt.*;

/**
 * The controller implemented as a JApplet to instantiate and connect the
 * HangmanGame (the model) and the HangmanGUI (the view) via adapters.
 * The controller also instantiates the adapters.
 * The adapters are implemented as anonymous inner classes.
 */
public class HangmanController extends JApplet{

    private HangmanGUI _gui;
    private HangmanGame _hangman;

    /**
     * Instantiates the HangmanGame, HangmanFrame, and connects them together
     * using anonymous inner class IPaintAdapter.
     * In this simplified version, there is no game playing, so there is no
     * need for loose and/or win adapters.
     */
    public void init() {
        _hangman = new HangmanGame();
        _gui = new HangmanGUI(this, new IPaintAdapter()  {
            public void paint(Graphics g) {
                // FOR ILLUSTRATION ONLY:
                System.out.println("anonymous IPaintAdapter.paint() calling " +
                    "_hangman.paint()...");

                _hangman.paint(g);
            }
        });
    }

    /**
     * Runs as a stand-alone GUI application with a main frame that contains
     * a HangmanController JApplet.
     * @param nu not used.
     */
    public static void main(String[] nu) {
        JFrame frame = new AFrame("Simple Hangman Drawing") {
            protected void initialize() {
                HangmanController controller = new HangmanController();
                controller.init();
                getContentPane().add(controller, "Center");
                setSize(400, 400);
                setVisible(true);
            }
        };
        frame.validate();
    }

}

