package model.bodyPart;

/**
 * Represents the 2 states of  an ABodyPart.
 */
abstract class ABodyState {

    /**
    * Executes a visitor pattern algorithm that depends on the state of the
    * ABodyPart.
    * @param algo The algorithm to be executed.
    * @param inp An arbitrary input parameter for the algorithm
    * @return The return value of the algorithm.
    */
    abstract Object execute(INEBody host, IBodyAlgo algo, Object inp);

    /**
     * Toggles the state of the ABodyPart host.
     * @param host 
     */
    abstract void toggleState(ABodyPart host);
}

