package model.bodyPart;

import java.awt.*;

/**
 * Represents an abstract word.
 * Presents itself to an IBodyAlgo visitor as a host with 3 cases:
 * <pre>
 * empty
 * visible
 * invisible
 * </pre>
 * @dependency model.bodyPart.IBodyAlgo uses
 */
public interface IBody {
    /**
     * Executes a visitor pattern algorithm that depends on the state of
     * the ABodyPart.
     * @param algo The algorithm to be executed.
     * @param inp An arbitrary input parameter for the algorithm
     * @return The return value of the algorithm.
     */
    abstract Object execute(IBodyAlgo algo, Object inp);
}

