package model.bodyPart;

import java.awt.*;

/**
 * Represents the abstract notion of a non-empty body parts list.
 * It also has 2 states: visible and invisible.
 * It  can toggle between its states.
 */
public interface INEBody extends IBody {
    /**
     * Abstract method to draw the body part onto the supplied Graphics context.
     * @param g The Graphics context to draw on.
     */
    public abstract void draw(Graphics g);
    public abstract void toggleState();
    public abstract IBody getRest();
}

