package model.bodyPart;
import java.awt.*;

/**
 * Concrete ABodyPart that represents a noose.  This is a special ABodyPart
 * that signals the loss of the game when it is drawn.
 * This ABodyPart should be the last element (i.e. inserted *first*) in a
 * list of ABodyParts for LoseOneAlgo and PaintAlgo to work properly.
 * NOTE: made public for testing purpose.
 */
public class NoosePart extends ABodyPart {

    /**
     * An ILoseAdapter used to signal when this body part is drawn,
     * and hence the end of the game.
     */
    private ILoseAdapter _loseAdapter;

    /**
    * The constructor for this class.
    * @param la The ILoseAdapter used to signal the end of the game.
    * @param r
    */
    public NoosePart(ILoseAdapter la, IBody r) {
        super(r);
        _loseAdapter = la;
    }


    /**
     * Draws the noose on the supplied Graphics context  and calls the lose()
     * method of its iLoseAdapter.
     * After calling iLoseAdapter.lose(),  iLoseAdapter is replaced with a
     * new no-operation ILoseAdapter so that the user only loses once.
     * @param g The Graphics context to draw on.
     */
    public void draw(Graphics g)  {
        g.fillRect(65,5,5,15);   // rope
        Color color = g.getColor();  //save the original color
        g.setColor(Color.white);
        g.fillArc(55,40,20,20,-10,-170);  // erase the original mouth
        g.setColor(color);
        g.fillArc(55,50,20,20,10,170);    // draw a new mouth
        // _loseAdapter.lose();      // The user has lost if noose is drawn!
    }
}